/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class BowUpgradeBuilder
implements RecipeBuilder {
    private final Upgrade upgrade;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;

    public BowUpgradeBuilder(Upgrade upgrade) {
        this.upgrade = upgrade;
    }

    public BowUpgradeBuilder define(Character character, TagKey<Item> tagKey) {
        return this.define(character, Ingredient.m_204132_(tagKey));
    }

    public BowUpgradeBuilder define(Character character, ItemLike itemLike) {
        return this.define(character, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
    }

    public BowUpgradeBuilder define(Character character, Ingredient ingredient) {
        if (this.key.containsKey(character)) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(character, ingredient);
        return this;
    }

    public BowUpgradeBuilder pattern(String str) {
        if (!this.rows.isEmpty() && str.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(str);
        return this;
    }

    public BowUpgradeBuilder unlockedBy(String name, CriterionTriggerInstance instance) {
        this.advancement.m_138386_(name, instance);
        return this;
    }

    public BowUpgradeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item m_142372_() {
        return (Item)ArcheryItems.UPGRADE.get();
    }

    public void m_176498_(Consumer<FinishedRecipe> pvd) {
        this.m_126140_(pvd, this.upgrade.getRegistryName());
    }

    public void m_126140_(Consumer<FinishedRecipe> p_126141_, ResourceLocation p_126142_) {
        this.ensureValid(p_126142_);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126142_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_126142_)).m_138360_(RequirementsStrategy.f_15979_);
        p_126141_.accept(new Result(p_126142_, this.upgrade, this.group == null ? "" : this.group, this.rows, this.key, this.advancement, new ResourceLocation(p_126142_.m_135827_(), "recipes/upgrades/" + p_126142_.m_135815_())));
    }

    private void ensureValid(ResourceLocation p_126144_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_126144_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_126144_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_126144_);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + p_126144_ + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126144_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Upgrade up;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Upgrade up, String group, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advancement, ResourceLocation adId) {
            this.id = id;
            this.up = up;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advancement = advancement;
            this.advancementId = adId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ArcheryItems.UPGRADE.getId().toString());
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("upgrade", this.up.getRegistryName().toString());
            jsonObject.add("nbt", (JsonElement)jsonObject2);
            json.add("result", (JsonElement)jsonObject);
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44076_;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

