/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.upgrade;

import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.upgrade.StatHolder;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class UpgradeItem
extends Item {
    private static final String KEY = "upgrade";

    @Nullable
    public static Upgrade getUpgrade(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(KEY)) {
            return null;
        }
        return (Upgrade)((Object)ArcheryRegister.UPGRADE.get().getValue(new ResourceLocation(tag.m_128461_(KEY))));
    }

    public static ItemStack setUpgrade(ItemStack stack, Upgrade upgrade) {
        stack.m_41784_().m_128359_(KEY, upgrade.getID());
        return stack;
    }

    public UpgradeItem(Item.Properties props) {
        super(props);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_220152_(tab)) {
            list.add((Object)new ItemStack((ItemLike)this));
            for (Upgrade upgrade : ArcheryRegister.UPGRADE.get().getValues()) {
                list.add((Object)UpgradeItem.setUpgrade(new ItemStack((ItemLike)this), upgrade));
            }
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return UpgradeItem.getUpgrade(stack) != null;
    }

    public Component m_7626_(ItemStack stack) {
        Upgrade upgrade = UpgradeItem.getUpgrade(stack);
        if (upgrade != null) {
            return Component.m_237115_((String)upgrade.getDescriptionId());
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        Upgrade upgrade = UpgradeItem.getUpgrade(stack);
        if (upgrade != null) {
            StatFeature stat;
            BowArrowFeature bowArrowFeature = upgrade.getFeature();
            if (bowArrowFeature instanceof PotionArrowFeature) {
                PotionArrowFeature arr = (PotionArrowFeature)bowArrowFeature;
                PotionArrowFeature.addTooltip(arr.instances(), list);
            }
            ArrayList<MutableComponent> temp = new ArrayList<MutableComponent>();
            upgrade.getFeature().addTooltip(temp);
            for (MutableComponent c : temp) {
                if (c.m_7383_().m_131135_() == null) {
                    c.m_130940_(ChatFormatting.GOLD);
                }
                list.add((Component)c);
            }
            BowArrowFeature bowArrowFeature2 = upgrade.getFeature();
            if (bowArrowFeature2 instanceof StatFeature && !(stat = (StatFeature)bowArrowFeature2).addStatHolder(new HashSet<StatHolder>(Set.of(StatHolder.DAMAGE)))) {
                list.add((Component)LangData.DAMAGE_UPGRADE.get(new Object[0]));
            }
        }
    }
}

