/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.events;

import dev.xkmc.l2archery.content.entity.GenericArrowEntity;
import dev.xkmc.l2archery.content.explosion.BaseExplosion;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.upgrade.StatHolder;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.content.upgrade.UpgradeItem;
import dev.xkmc.l2archery.init.registrate.ArcheryEffects;
import dev.xkmc.l2library.util.Proxy;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GenericEventHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void fov(ComputeFovModifierEvent event) {
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GenericBowItem) {
            GenericBowItem bow = (GenericBowItem)item;
            float f = event.getFovModifier();
            float i = player.m_21252_();
            MobEffectInstance ins = player.m_21124_((MobEffect)ArcheryEffects.QUICK_PULL.get());
            if (ins != null) {
                i = (float)((double)i * (1.5 + 0.5 * (double)ins.m_19564_()));
            }
            BowData data = BowData.of(bow, stack);
            float p = data.getConfig().fov_time();
            event.setNewFovModifier(f * (1.0f - Math.min(1.0f, i / p) * data.getConfig().fov()));
        }
    }

    @SubscribeEvent
    public static void onDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        if (explosion instanceof BaseExplosion) {
            BaseExplosion exp = (BaseExplosion)explosion;
            event.getAffectedEntities().removeIf(e -> !exp.hurtEntity((Entity)e));
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        Item item = left.m_41720_();
        if (item instanceof GenericBowItem) {
            GenericBowItem bow = (GenericBowItem)item;
            if (right.m_41720_() instanceof UpgradeItem) {
                Upgrade upgrade = UpgradeItem.getUpgrade(right);
                FeatureList list = bow.getFeatures(left);
                if (upgrade == null) {
                    return;
                }
                if (!GenericEventHandler.allowUpgrade(bow, left, upgrade)) {
                    return;
                }
                int count = GenericBowItem.getUpgrades(left).size();
                ItemStack result = left.m_41777_();
                GenericBowItem.addUpgrade(result, upgrade);
                GenericBowItem.remakeEnergy(result);
                event.setOutput(result);
                event.setMaterialCost(1);
                event.setCost(8 << count);
            }
        }
    }

    public static boolean allowUpgrade(GenericBowItem bow, ItemStack bowStack, Upgrade upgrade) {
        FeatureList list = bow.getFeatures(bowStack);
        if (!upgrade.allow(bow)) {
            return false;
        }
        int remain = bow.getUpgradeSlot(bowStack);
        if (remain <= 0) {
            return false;
        }
        if (!list.allow(upgrade.getFeature())) {
            return false;
        }
        BowArrowFeature bowArrowFeature = upgrade.getFeature();
        if (bowArrowFeature instanceof StatFeature) {
            StatFeature stat = (StatFeature)bowArrowFeature;
            List<Upgrade> ups = GenericBowItem.getUpgrades(bowStack);
            TreeSet<StatHolder> set = new TreeSet<StatHolder>();
            for (Upgrade up : ups) {
                BowArrowFeature bowArrowFeature2 = up.getFeature();
                if (!(bowArrowFeature2 instanceof StatFeature)) continue;
                StatFeature f = (StatFeature)bowArrowFeature2;
                f.addStatHolder(set);
            }
            return stat.addStatHolder(set);
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onArrowHit(LivingAttackEvent event) {
        IndirectEntityDamageSource ind;
        Entity entity;
        DamageSource damageSource = event.getSource();
        if (damageSource instanceof IndirectEntityDamageSource && (entity = (ind = (IndirectEntityDamageSource)damageSource).m_7640_()) instanceof GenericArrowEntity) {
            GenericArrowEntity arrow = (GenericArrowEntity)entity;
            arrow.onHurtEntity(ind);
        }
    }

    @SubscribeEvent
    public static void onGrind(GrindstoneEvent.OnplaceItem event) {
        Item item = event.getTopItem().m_41720_();
        if (item instanceof GenericBowItem) {
            GenericBowItem bow = (GenericBowItem)item;
            ItemStack copy = event.getTopItem().m_41777_();
            if (GenericBowItem.getUpgrades(copy).size() > 0) {
                copy.m_41784_().m_128473_("upgrades");
                GenericBowItem.remakeEnergy(copy);
                event.setOutput(copy);
                event.setXp(0);
            }
        }
    }
}

