/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.init;

import dev.xkmc.l2archery.content.client.ArrowDisplayOverlay;
import dev.xkmc.l2archery.content.client.BowFluxBarRenderer;
import dev.xkmc.l2archery.content.client.BowInfoOverlay;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class L2ArcheryClient {
    public static final List<GenericBowItem> BOW_LIKE = new ArrayList<GenericBowItem>();

    public static void onCtorClient(IEventBus bus, IEventBus eventBus) {
        bus.register(L2ArcheryClient.class);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(L2ArcheryClient::registerItemProperties);
    }

    public static void registerItemProperties() {
        for (GenericBowItem bow : BOW_LIKE) {
            ItemProperties.register((Item)bow, (ResourceLocation)new ResourceLocation("pull"), (stack, level, entity, i) -> entity == null || entity.m_21211_() != stack ? 0.0f : bow.getPullForTime(entity, stack.m_41779_() - entity.m_21212_()));
            ItemProperties.register((Item)bow, (ResourceLocation)new ResourceLocation("pulling"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        }
    }

    @SubscribeEvent
    public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
        for (GenericBowItem bow : BOW_LIKE) {
            event.register((ItemLike)bow, BowFluxBarRenderer::renderFluxBar);
        }
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "arrow", (IGuiOverlay)new ArrowDisplayOverlay());
        event.registerBelow(VanillaGuiOverlay.HOTBAR.id(), "info", (IGuiOverlay)new BowInfoOverlay());
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
    }
}

