/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.init.registrate;

import dev.xkmc.l2archery.content.effects.QuickPullEffect;
import dev.xkmc.l2archery.content.effects.RunBowEffect;
import dev.xkmc.l2archery.init.L2Archery;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2library.repack.registrate.AbstractRegistrate;
import dev.xkmc.l2library.repack.registrate.builders.NoConfigBuilder;
import dev.xkmc.l2library.repack.registrate.util.entry.ItemEntry;
import dev.xkmc.l2library.repack.registrate.util.entry.RegistryEntry;
import dev.xkmc.l2library.repack.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.registries.ForgeRegistries;

public class ArcheryEffects {
    public static final List<RegistryEntry<? extends Potion>> POTION_LIST = new ArrayList<RegistryEntry<? extends Potion>>();
    public static final Map<String, String> NAME_CACHE = new HashMap<String, String>();
    public static final RegistryEntry<RunBowEffect> RUN_BOW = ArcheryEffects.genEffect("run_bow", "Sprinting Archer", () -> new RunBowEffect(MobEffectCategory.BENEFICIAL, 0xFFFFFF));
    public static final RegistryEntry<QuickPullEffect> QUICK_PULL = ArcheryEffects.genEffect("quick_pull", "Fast Pulling", () -> new QuickPullEffect(MobEffectCategory.BENEFICIAL, 0xFFFFFF));
    private static final List<Runnable> TEMP = new ArrayList<Runnable>();

    public static <T extends MobEffect> RegistryEntry<T> genEffect(String name, String lang, NonNullSupplier<T> sup) {
        NAME_CACHE.put(name, lang);
        return ((NoConfigBuilder)((NoConfigBuilder)L2Archery.REGISTRATE.entry(name, cb -> new NoConfigBuilder((AbstractRegistrate)L2Archery.REGISTRATE, (Object)L2Archery.REGISTRATE, name, cb, ForgeRegistries.Keys.MOB_EFFECTS, sup))).lang(MobEffect::m_19481_)).register();
    }

    public static void registerBrewingRecipe() {
        TEMP.forEach(Runnable::run);
    }

    public static void register() {
        ArcheryEffects.regPotion2("run_bow", () -> RUN_BOW.get(), () -> ((ItemEntry)LCItems.CAPTURED_WIND).get(), 1200, 3600);
        ArcheryEffects.regPotion3("quick_pull", () -> QUICK_PULL.get(), () -> ((ItemEntry)LCItems.STORM_CORE).get(), 600, 1200, 3600, 0, 1);
    }

    private static <T extends Potion> RegistryEntry<T> genPotion(String name, NonNullSupplier<T> sup) {
        RegistryEntry ans = ((NoConfigBuilder)L2Archery.REGISTRATE.entry(name, cb -> new NoConfigBuilder((AbstractRegistrate)L2Archery.REGISTRATE, (Object)L2Archery.REGISTRATE, name, cb, ForgeRegistries.Keys.POTIONS, sup))).register();
        POTION_LIST.add((RegistryEntry<? extends Potion>)ans);
        return ans;
    }

    private static void regPotion2(String id, Supplier<MobEffect> sup, Supplier<Item> item, int dur, int durLong) {
        RegistryEntry potion = ArcheryEffects.genPotion(id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), dur)}));
        RegistryEntry longPotion = ArcheryEffects.genPotion("long_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durLong)}));
        TEMP.add(() -> {
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)item.get()), (Potion)((Potion)potion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42451_, (Potion)((Potion)longPotion.get()));
        });
    }

    private static void regPotion3(String id, Supplier<MobEffect> sup, Supplier<Item> item, int durStrong, int dur, int durLong, int amp, int ampStrong) {
        RegistryEntry potion = ArcheryEffects.genPotion(id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), dur, amp)}));
        RegistryEntry longPotion = ArcheryEffects.genPotion("long_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durLong, amp)}));
        RegistryEntry strongPotion = ArcheryEffects.genPotion("strong_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durStrong, ampStrong)}));
        TEMP.add(() -> {
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)item.get()), (Potion)((Potion)potion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42451_, (Potion)((Potion)longPotion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42525_, (Potion)((Potion)strongPotion.get()));
        });
    }
}

