/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.init.registrate;

import com.google.common.collect.ImmutableList;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.DamageArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.EnderArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.ExplodeArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.FireArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.NoFallArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.VoidArrowFeature;
import dev.xkmc.l2archery.content.feature.bow.EnderShootFeature;
import dev.xkmc.l2archery.content.feature.bow.FluxFeature;
import dev.xkmc.l2archery.content.feature.bow.GlowTargetAimFeature;
import dev.xkmc.l2archery.content.feature.bow.PullEffectFeature;
import dev.xkmc.l2archery.content.feature.bow.WindBowFeature;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.item.ArrowConfig;
import dev.xkmc.l2archery.content.item.BowConfig;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.content.upgrade.UpgradeItem;
import dev.xkmc.l2archery.init.L2Archery;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.data.TagGen;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.repack.registrate.builders.ItemBuilder;
import dev.xkmc.l2library.repack.registrate.providers.DataGenContext;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateItemModelProvider;
import dev.xkmc.l2library.repack.registrate.util.entry.ItemEntry;
import dev.xkmc.l2library.repack.registrate.util.entry.RegistryEntry;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class ArcheryItems {
    public static final Tab TAB_PROF = new Tab("archery", () -> STARTER_BOW);
    public static final ItemEntry<GenericBowItem> STARTER_BOW;
    public static final ItemEntry<GenericBowItem> IRON_BOW;
    public static final ItemEntry<GenericBowItem> MASTER_BOW;
    public static final ItemEntry<GenericBowItem> MAGNIFY_BOW;
    public static final ItemEntry<GenericBowItem> GLOW_AIM_BOW;
    public static final ItemEntry<GenericBowItem> ENDER_AIM_BOW;
    public static final ItemEntry<GenericBowItem> EAGLE_BOW;
    public static final ItemEntry<GenericBowItem> WIND_BOW;
    public static final ItemEntry<GenericBowItem> EXPLOSION_BOW;
    public static final ItemEntry<GenericBowItem> FLAME_BOW;
    public static final ItemEntry<GenericBowItem> FROZE_BOW;
    public static final ItemEntry<GenericBowItem> STORM_BOW;
    public static final ItemEntry<GenericBowItem> BLACKSTONE_BOW;
    public static final ItemEntry<GenericBowItem> WINTER_BOW;
    public static final ItemEntry<GenericBowItem> TURTLE_BOW;
    public static final ItemEntry<GenericBowItem> EARTH_BOW;
    public static final ItemEntry<GenericBowItem> GAIA_BOW;
    public static final ItemEntry<GenericBowItem> VOID_BOW;
    public static final ItemEntry<GenericBowItem> SUN_BOW;
    public static final ItemEntry<GenericArrowItem> STARTER_ARROW;
    public static final ItemEntry<GenericArrowItem> COPPER_ARROW;
    public static final ItemEntry<GenericArrowItem> IRON_ARROW;
    public static final ItemEntry<GenericArrowItem> GOLD_ARROW;
    public static final ItemEntry<GenericArrowItem> OBSIDIAN_ARROW;
    public static final ItemEntry<GenericArrowItem> NO_FALL_ARROW;
    public static final ItemEntry<GenericArrowItem> ENDER_ARROW;
    public static final ItemEntry<GenericArrowItem> TNT_1_ARROW;
    public static final ItemEntry<GenericArrowItem> TNT_2_ARROW;
    public static final ItemEntry<GenericArrowItem> TNT_3_ARROW;
    public static final ItemEntry<GenericArrowItem> FIRE_1_ARROW;
    public static final ItemEntry<GenericArrowItem> FIRE_2_ARROW;
    public static final ItemEntry<GenericArrowItem> DESTROYER_ARROW;
    public static final ItemEntry<GenericArrowItem> ICE_ARROW;
    public static final ItemEntry<GenericArrowItem> DISPELL_ARROW;
    public static final ItemEntry<GenericArrowItem> ACID_ARROW;
    public static final ItemEntry<GenericArrowItem> BLACKSTONE_ARROW;
    public static final ItemEntry<GenericArrowItem> DIAMOND_ARROW;
    public static final ItemEntry<GenericArrowItem> QUARTZ_ARROW;
    public static final ItemEntry<GenericArrowItem> WITHER_ARROW;
    public static final ItemEntry<GenericArrowItem> STORM_ARROW;
    public static final ItemEntry<GenericArrowItem> VOID_ARROW;
    public static final ItemEntry<UpgradeItem> UPGRADE;
    public static final RegistryEntry<Upgrade> GLOW_UP;
    public static final RegistryEntry<Upgrade> NO_FALL_UP;
    public static final RegistryEntry<Upgrade> FIRE_UP;
    public static final RegistryEntry<Upgrade> ICE_UP;
    public static final RegistryEntry<Upgrade> EXPLOSION_UP;
    public static final RegistryEntry<Upgrade> ENDER_UP;
    public static final RegistryEntry<Upgrade> MAGNIFY_UP_1;
    public static final RegistryEntry<Upgrade> MAGNIFY_UP_2;
    public static final RegistryEntry<Upgrade> MAGNIFY_UP_3;
    public static final RegistryEntry<Upgrade> DAMAGE_UP;
    public static final RegistryEntry<Upgrade> PUNCH_UP;
    public static final RegistryEntry<Upgrade> BLACKSTONE_UP;
    public static final RegistryEntry<Upgrade> HARM_UP;
    public static final RegistryEntry<Upgrade> HEAL_UP;
    public static final RegistryEntry<Upgrade> SHINE_UP;
    public static final RegistryEntry<Upgrade> LEVITATE_UP;
    public static final RegistryEntry<Upgrade> SUPERDAMAGE_UP;
    public static final RegistryEntry<Upgrade> RAILGUN_UP;
    public static final RegistryEntry<Upgrade> FLUX_UP;
    public static final RegistryEntry<Upgrade> FLOAT_UP;
    public static final RegistryEntry<Upgrade> SLOW_UP;
    private static final float[] BOW_PULL_VALS;

    public static void register() {
    }

    public static ItemBuilder<GenericBowItem, L2Registrate> genBow(String id, int rank, int durability) {
        return ArcheryItems.genBow(id, rank, durability, e -> {});
    }

    public static ItemBuilder<GenericBowItem, L2Registrate> genBow(String id, int rank, int durability, Consumer<ImmutableList.Builder<BowArrowFeature>> consumer) {
        ImmutableList.Builder f = ImmutableList.builder();
        consumer.accept((ImmutableList.Builder<BowArrowFeature>)f);
        return L2Archery.REGISTRATE.item(id, p -> new GenericBowItem(p.m_41487_(1).m_41503_(durability), new BowConfig(new ResourceLocation("l2archery", id), rank, (List<BowArrowFeature>)f.build()))).model(ArcheryItems::createBowModel).defaultLang().tag(new TagKey[]{TagGen.FORGE_BOWS, TagGen.PROF_BOWS});
    }

    public static <T extends GenericBowItem> void createBowModel(DataGenContext<Item, T> ctx, RegistrateItemModelProvider pvd) {
        ItemModelBuilder builder = (ItemModelBuilder)pvd.withExistingParent(ctx.getName(), "minecraft:bow");
        builder.texture("layer0", "item/bow/" + ctx.getName() + "/bow");
        for (int i = 0; i < 3; ++i) {
            String name = ctx.getName() + "/bow_pulling_" + i;
            ItemModelBuilder ret = (ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder("item/bow/" + name)).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/bow_pulling_" + i));
            ret.texture("layer0", "item/bow/" + name);
            ItemModelBuilder.OverrideBuilder override = builder.override();
            override.predicate(new ResourceLocation("pulling"), 1.0f);
            if (BOW_PULL_VALS[i] > 0.0f) {
                override.predicate(new ResourceLocation("pull"), BOW_PULL_VALS[i]);
            }
            override.model((ModelFile)new ModelFile.UncheckedModelFile("l2archery:item/bow/" + name));
        }
    }

    public static ItemEntry<GenericArrowItem> genArrow(String id, boolean is_inf) {
        return ArcheryItems.genArrow(id, is_inf, e -> {}).register();
    }

    public static ItemBuilder<GenericArrowItem, L2Registrate> genArrow(String id, boolean is_inf, Consumer<ImmutableList.Builder<BowArrowFeature>> consumer) {
        ImmutableList.Builder f = ImmutableList.builder();
        consumer.accept((ImmutableList.Builder<BowArrowFeature>)f);
        return L2Archery.REGISTRATE.item(id, p -> new GenericArrowItem((Item.Properties)p, new ArrowConfig(new ResourceLocation("l2archery", id), is_inf, (List<BowArrowFeature>)f.build()))).model(ArcheryItems::createArrowModel).tag(new TagKey[]{TagGen.FORGE_ARROWS, TagGen.PROF_ARROWS});
    }

    public static <T extends GenericArrowItem> void createArrowModel(DataGenContext<Item, T> ctx, RegistrateItemModelProvider pvd) {
        pvd.generated(ctx, new ResourceLocation[]{new ResourceLocation("l2archery", "item/arrow/" + ctx.getName())});
    }

    public static RegistryEntry<Upgrade> genUpgrade(String str, Supplier<BowArrowFeature> sup) {
        return L2Archery.REGISTRATE.generic(ArcheryRegister.UPGRADE, str, () -> new Upgrade(sup)).defaultLang().register();
    }

    static {
        L2Archery.REGISTRATE.creativeModeTab(() -> TAB_PROF);
        STARTER_BOW = ArcheryItems.genBow("starter_bow", 0, 600).register();
        IRON_BOW = ArcheryItems.genBow("iron_bow", 1, 1200).register();
        MASTER_BOW = ArcheryItems.genBow("master_bow", 1, 1200).register();
        GLOW_AIM_BOW = ArcheryItems.genBow("glow_aim_bow", 1, 300, e -> e.add((Object)new NoFallArrowFeature(40)).add((Object)new GlowTargetAimFeature(128))).lang("Sniper Bow").register();
        MAGNIFY_BOW = ArcheryItems.genBow("magnify_bow", 2, 300, e -> e.add((Object)new NoFallArrowFeature(40)).add((Object)new GlowTargetAimFeature(128))).lang("Sniper Bow with Lens").register();
        ENDER_AIM_BOW = ArcheryItems.genBow("ender_aim_bow", 2, 600, e -> e.add((Object)new EnderShootFeature(128))).lang("Ender Bow").register();
        EAGLE_BOW = ArcheryItems.genBow("eagle_bow", 2, 600, e -> e.add((Object)new DamageArrowFeature((a, s) -> s.m_19380_(), () -> LangData.FEATURE_PIERCE_ARMOR.get(new Object[0])))).register();
        EXPLOSION_BOW = ArcheryItems.genBow("explosion_bow", 2, 300, e -> e.add((Object)new ExplodeArrowFeature(3.0f, true, false))).register();
        FLAME_BOW = ArcheryItems.genBow("flame_bow", 2, 600, e -> e.add((Object)new FireArrowFeature(100))).lang("Blazing Bow").register();
        FROZE_BOW = ArcheryItems.genBow("froze_bow", 2, 600).lang("Freezing Bow").register();
        BLACKSTONE_BOW = ArcheryItems.genBow("slow_bow", 2, 600).lang("Bow of Seal").register();
        STORM_BOW = ArcheryItems.genBow("storm_bow", 2, 600, e -> e.add((Object)new ExplodeArrowFeature(3.0f, false, false))).lang("Approaching Storm").register();
        TURTLE_BOW = ArcheryItems.genBow("turtle_bow", 2, 600, e -> e.add((Object)new PullEffectFeature(List.of(() -> new MobEffectInstance(MobEffects.f_19597_, 40, 3), () -> new MobEffectInstance(MobEffects.f_19606_, 40, 2))))).register();
        EARTH_BOW = ArcheryItems.genBow("earth_bow", 2, 600, e -> e.add((Object)new PullEffectFeature(List.of(() -> new MobEffectInstance(MobEffects.f_19597_, 60, 5), () -> new MobEffectInstance(MobEffects.f_19606_, 60, 3))))).lang("Bow of the Earth").register();
        WIND_BOW = ArcheryItems.genBow("wind_bow", 3, 600, e -> e.add((Object)new NoFallArrowFeature(40)).add((Object)new WindBowFeature()).add((Object)new PullEffectFeature(List.of(() -> new MobEffectInstance(MobEffects.f_19596_, 100, 1))))).lang("Bless of Favonius").register();
        WINTER_BOW = ArcheryItems.genBow("winter_bow", 3, 600, e -> e.add((Object)new ExplodeArrowFeature(3.0f, false, false))).lang("Ever Freezing Night").register();
        GAIA_BOW = ArcheryItems.genBow("gaia_bow", 3, 600, e -> e.add((Object)new PullEffectFeature(List.of(() -> new MobEffectInstance((MobEffect)LCEffects.STONE_CAGE.get(), 80, 0), () -> new MobEffectInstance(MobEffects.f_19606_, 80, 4))))).lang("Bless of Gaia").register();
        VOID_BOW = ArcheryItems.genBow("void_bow", 3, 300, e -> e.add((Object)new EnderShootFeature(128)).add((Object)new DamageArrowFeature((a, s) -> s.m_19380_().m_19382_().m_19381_(), () -> LangData.FEATURE_PIERCE_INVUL.get(new Object[0])))).lang("Sight of the Void").register();
        SUN_BOW = ArcheryItems.genBow("sun_bow", 3, 600, e -> e.add((Object)new FireArrowFeature(200)).add((Object)new ExplodeArrowFeature(4.0f, true, false))).lang("Bless of Helios").register();
        STARTER_ARROW = ArcheryItems.genArrow("starter_arrow", true);
        COPPER_ARROW = ArcheryItems.genArrow("copper_arrow", false);
        IRON_ARROW = ArcheryItems.genArrow("iron_arrow", false);
        GOLD_ARROW = ArcheryItems.genArrow("gold_arrow", false);
        OBSIDIAN_ARROW = ArcheryItems.genArrow("obsidian_arrow", false);
        BLACKSTONE_ARROW = ArcheryItems.genArrow("blackstone_arrow", false);
        QUARTZ_ARROW = ArcheryItems.genArrow("quartz_arrow", false);
        DIAMOND_ARROW = ArcheryItems.genArrow("diamond_arrow", false);
        DESTROYER_ARROW = ArcheryItems.genArrow("destroyer_arrow", false);
        NO_FALL_ARROW = ArcheryItems.genArrow("no_fall_arrow", false, e -> e.add((Object)new NoFallArrowFeature(40))).lang("Anti-Gravity Arrow").register();
        ENDER_ARROW = ArcheryItems.genArrow("ender_arrow", false, e -> e.add((Object)new EnderArrowFeature())).register();
        TNT_1_ARROW = ArcheryItems.genArrow("tnt_arrow_lv1", false, e -> e.add((Object)new ExplodeArrowFeature(2.0f, true, false))).lang("Explosion Arrow").register();
        TNT_2_ARROW = ArcheryItems.genArrow("tnt_arrow_lv2", false, e -> e.add((Object)new ExplodeArrowFeature(4.0f, true, false))).lang("TNT Arrow").register();
        TNT_3_ARROW = ArcheryItems.genArrow("tnt_arrow_lv3", false, e -> e.add((Object)new ExplodeArrowFeature(6.0f, true, false))).lang("End Crystal Arrow").register();
        FIRE_1_ARROW = ArcheryItems.genArrow("fire_arrow_lv1", false, e -> e.add((Object)new FireArrowFeature(100))).lang("Soul Fire Arrow").register();
        FIRE_2_ARROW = ArcheryItems.genArrow("fire_arrow_lv2", false, e -> e.add((Object)new FireArrowFeature(200))).lang("Cursed Fire Arrow").register();
        ICE_ARROW = ArcheryItems.genArrow("frozen_arrow", false);
        ACID_ARROW = ArcheryItems.genArrow("acid_arrow", false);
        DISPELL_ARROW = ArcheryItems.genArrow("dispell_arrow", false, e -> e.add((Object)new DamageArrowFeature((a, s) -> s.m_19382_(), () -> LangData.FEATURE_PIERCE_MAGIC.get(new Object[0])))).register();
        WITHER_ARROW = ArcheryItems.genArrow("wither_arrow", false, e -> e.add((Object)new DamageArrowFeature((a, s) -> s.m_19389_().m_19380_(), () -> LangData.FEATURE_PIERCE_ARMOR.get(new Object[0])))).register();
        STORM_ARROW = ArcheryItems.genArrow("storm_arrow", false, e -> e.add((Object)new ExplodeArrowFeature(3.0f, false, false))).register();
        VOID_ARROW = ArcheryItems.genArrow("void_arrow", false, e -> e.add((Object)new DamageArrowFeature((a, s) -> s.m_19380_().m_19382_().m_19381_(), () -> LangData.FEATURE_PIERCE_INVUL.get(new Object[0]))).add((Object)new VoidArrowFeature())).register();
        UPGRADE = L2Archery.REGISTRATE.item("upgrade", UpgradeItem::new).defaultModel().defaultLang().register();
        MAGNIFY_UP_1 = ArcheryItems.genUpgrade("magnify_x2", () -> new StatFeature(2.0f, 10, 1.0f, 0, 1.0f));
        MAGNIFY_UP_2 = ArcheryItems.genUpgrade("magnify_x4", () -> new StatFeature(4.0f, 30, 1.0f, 0, 1.0f));
        MAGNIFY_UP_3 = ArcheryItems.genUpgrade("magnify_x8", () -> new StatFeature(8.0f, 50, 1.0f, 0, 1.0f));
        DAMAGE_UP = ArcheryItems.genUpgrade("damage", () -> new StatFeature(1.0f, 1, 2.0f, 0, 1.0f));
        SUPERDAMAGE_UP = ArcheryItems.genUpgrade("super_damage", () -> new StatFeature(1.0f, 1, 3.0f, 0, 1.0f));
        PUNCH_UP = ArcheryItems.genUpgrade("punch", () -> new StatFeature(1.0f, 1, 1.0f, 3, 1.0f));
        GLOW_UP = ArcheryItems.genUpgrade("glow", () -> new GlowTargetAimFeature(128));
        NO_FALL_UP = ArcheryItems.genUpgrade("anti_gravity", () -> new NoFallArrowFeature(40));
        FIRE_UP = ArcheryItems.genUpgrade("soul_fire", () -> new PotionArrowFeature(List.of(new MobEffectInstance((MobEffect)LCEffects.FLAME.get(), 100, 0))));
        ICE_UP = ArcheryItems.genUpgrade("frozen", () -> new PotionArrowFeature(List.of(new MobEffectInstance((MobEffect)LCEffects.ICE.get(), 600, 0))));
        EXPLOSION_UP = ArcheryItems.genUpgrade("explosion", () -> new ExplodeArrowFeature(3.0f, true, false));
        ENDER_UP = ArcheryItems.genUpgrade("void", () -> new EnderShootFeature(128));
        BLACKSTONE_UP = ArcheryItems.genUpgrade("blackstone", () -> new PotionArrowFeature(List.of(new MobEffectInstance((MobEffect)LCEffects.STONE_CAGE.get(), 100, 0))));
        HARM_UP = ArcheryItems.genUpgrade("harm", () -> new PotionArrowFeature(List.of(new MobEffectInstance(MobEffects.f_19602_, 1, 1))));
        HEAL_UP = ArcheryItems.genUpgrade("heal", () -> new PotionArrowFeature(List.of(new MobEffectInstance(MobEffects.f_19601_, 1, 1))));
        SHINE_UP = ArcheryItems.genUpgrade("glowing", () -> new PotionArrowFeature(List.of(new MobEffectInstance(MobEffects.f_19619_, 600, 0))));
        LEVITATE_UP = ArcheryItems.genUpgrade("levitate", () -> new PotionArrowFeature(List.of(new MobEffectInstance(MobEffects.f_19620_, 300, 0))));
        RAILGUN_UP = ArcheryItems.genUpgrade("railgun", () -> new StatFeature(1.0f, 1, 1.0f, 0, 100.0f));
        FLUX_UP = ArcheryItems.genUpgrade("flux_up", () -> FluxFeature.DEFAULT);
        FLOAT_UP = ArcheryItems.genUpgrade("levitation", () -> new PotionArrowFeature(List.of(new MobEffectInstance(MobEffects.f_19620_, 100, 0))));
        SLOW_UP = ArcheryItems.genUpgrade("slowness", () -> new PotionArrowFeature(List.of(new MobEffectInstance(MobEffects.f_19597_, 200, 5))));
        BOW_PULL_VALS = new float[]{0.0f, 0.65f, 0.9f};
    }

    public static class Tab
    extends CreativeModeTab {
        private final Supplier<ItemEntry> icon;

        public Tab(String id, Supplier<ItemEntry> icon) {
            super("l2archery." + id);
            this.icon = icon;
        }

        public ItemStack m_6976_() {
            return this.icon.get().asStack();
        }
    }
}

