/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.compat.fabric.rei;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.playdate.common.recipes.ToyBenchRecipe;
import tech.thatgravyboat.playdate.common.registry.ModItems;

public class ToyBenchCategory
implements DisplayCategory<ToyBenchDisplay> {
    public static final CategoryIdentifier<ToyBenchDisplay> ID = CategoryIdentifier.of((String)"playdate", (String)"toy_bench");

    public CategoryIdentifier<? extends ToyBenchDisplay> getCategoryIdentifier() {
        return ID;
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"gui.playdate.toy_bench");
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)((class_1935)ModItems.TOY_BENCH.get()));
    }

    public List<Widget> setupDisplay(ToyBenchDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y + 18)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 95, startPoint.y + 19)));
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                slots.add(Widgets.createSlot((Point)new Point(startPoint.x + 1 + x * 18, startPoint.y + 1 + y * 18)).markInput());
            }
        }
        display.getInputIngredients().forEach(ingredient -> ((Slot)slots.get(ingredient.getIndex())).entries((Collection)ingredient.get()));
        widgets.addAll(slots);
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y + 19)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        return widgets;
    }

    @Nullable
    public DisplayMerger<ToyBenchDisplay> getDisplayMerger() {
        return DisplayCategory.getContentMerger();
    }

    public record ToyBenchDisplay(ToyBenchRecipe recipe) implements SimpleGridMenuDisplay
    {
        public List<EntryIngredient> getInputEntries() {
            return EntryIngredients.ofIngredients(this.recipe.method_8117());
        }

        public List<EntryIngredient> getOutputEntries() {
            return List.of(EntryIngredients.of((class_1799)this.recipe.method_8110()));
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return ID;
        }

        public int getWidth() {
            return this.recipe.width();
        }

        public int getHeight() {
            return this.recipe.height();
        }

        public List<InputIngredient<EntryStack<?>>> getInputIngredients() {
            HashMap<IntIntImmutablePair, InputIngredient> grid = new HashMap<IntIntImmutablePair, InputIngredient>();
            List<EntryIngredient> inputEntries = this.getInputEntries();
            for (int i = 0; i < inputEntries.size(); ++i) {
                EntryIngredient stacks = inputEntries.get(i);
                if (stacks.isEmpty()) continue;
                int index = 3 * ((i - i % this.getWidth()) / this.getWidth()) + i % this.getWidth();
                grid.put(new IntIntImmutablePair(i % this.getWidth(), i / this.getWidth()), InputIngredient.of((int)index, (List)stacks));
            }
            ArrayList list = new ArrayList(9);
            for (int i = 0; i < 9; ++i) {
                list.add(InputIngredient.empty((int)i));
            }
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    InputIngredient ingredient = (InputIngredient)grid.get(new IntIntImmutablePair(x, y));
                    if (ingredient == null) continue;
                    list.set(3 * y + x, ingredient);
                }
            }
            return list;
        }
    }
}

