/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.registry.api;

import java.util.EnumMap;
import java.util.function.Supplier;
import tech.thatgravyboat.playdate.common.registry.api.RegistryEntries;
import tech.thatgravyboat.playdate.common.registry.api.RegistryEntry;
import tech.thatgravyboat.playdate.common.registry.api.ResourcefulRegistry;
import tech.thatgravyboat.playdate.common.registry.api.ResourcefulRegistryChild;

public class EnumResourcefulRegistryChild<E extends Enum<E>, T>
extends ResourcefulRegistryChild<T> {
    private final EnumMap<E, RegistryEntries<T>> entries;

    public EnumResourcefulRegistryChild(Class<E> enumClass, ResourcefulRegistry<T> parent) {
        super(parent);
        this.entries = new EnumMap(enumClass);
    }

    public <I extends T> RegistryEntry<I> register(E enumValue, String id, Supplier<I> supplier) {
        return this.entries.computeIfAbsent(enumValue, a -> new RegistryEntries()).add(super.register(id, supplier));
    }

    public RegistryEntries<T> getEntries(E enumValue) {
        return this.entries.get(enumValue);
    }
}

