/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.cabbagebeta.gen.beta;

import cyborgcabbage.cabbagebeta.gen.beta.biome.BiomeGenBase;
import cyborgcabbage.cabbagebeta.gen.beta.noise.NoiseGeneratorOctaves2;
import java.util.Random;
import net.minecraft.class_3532;

public class BetaBiomes {
    private final NoiseGeneratorOctaves2 temperatureGenerator;
    private final NoiseGeneratorOctaves2 humidityGenrator;
    private final NoiseGeneratorOctaves2 noise9;
    public double[] temperature;
    public double[] humidity;
    public double[] biomeJitter;
    public BiomeGenBase[] biomeRegion;
    public BiomeGenBase[] biomes;

    public BetaBiomes(long seed) {
        this.temperatureGenerator = new NoiseGeneratorOctaves2(new Random(seed * 9871L), 4);
        this.humidityGenrator = new NoiseGeneratorOctaves2(new Random(seed * 39811L), 4);
        this.noise9 = new NoiseGeneratorOctaves2(new Random(seed * 543321L), 2);
    }

    public BiomeGenBase getBiomeAtBlock(int x, int z) {
        return this.getBiomesInRegion(x, z, 1, 1)[0];
    }

    public double getTemperature(int i1, int i2) {
        this.temperature = this.temperatureGenerator.func_4112_a(this.temperature, i1, i2, 1, 1, 0.025f, 0.025f, 0.5);
        return this.temperature[0];
    }

    public BiomeGenBase[] getBiomesInRegion(int xPos, int zPos, int xSize, int zSize) {
        this.biomeRegion = this.generateBiomes(this.biomeRegion, xPos, zPos, xSize, zSize);
        return this.biomeRegion;
    }

    public double[] getTemperatures(double[] d1, int i2, int i3, int i4, int i5) {
        if (d1 == null || d1.length < i4 * i5) {
            d1 = new double[i4 * i5];
        }
        d1 = this.temperatureGenerator.func_4112_a(d1, i2, i3, i4, i5, 0.025f, 0.025f, 0.25);
        this.biomeJitter = this.noise9.func_4112_a(this.biomeJitter, i2, i3, i4, i5, 0.25, 0.25, 0.5882352941176471);
        int i6 = 0;
        for (int i7 = 0; i7 < i4; ++i7) {
            for (int i8 = 0; i8 < i5; ++i8) {
                double d9 = this.biomeJitter[i6] * 1.1 + 0.5;
                double d11 = 0.01;
                double d13 = 1.0 - d11;
                double d15 = (d1[i6] * 0.15 + 0.7) * d13 + d9 * d11;
                if ((d15 = 1.0 - (1.0 - d15) * (1.0 - d15)) < 0.0) {
                    d15 = 0.0;
                }
                if (d15 > 1.0) {
                    d15 = 1.0;
                }
                d1[i6] = d15;
                ++i6;
            }
        }
        return d1;
    }

    public BiomeGenBase[] generateBiomes(BiomeGenBase[] biomes, int xChunk, int zChunk, int xSize, int zSize) {
        if (biomes == null || biomes.length < xSize * zSize) {
            biomes = new BiomeGenBase[xSize * zSize];
        }
        this.temperature = this.temperatureGenerator.func_4112_a(this.temperature, xChunk, zChunk, xSize, xSize, 0.025f, 0.025f, 0.25);
        this.humidity = this.humidityGenrator.func_4112_a(this.humidity, xChunk, zChunk, xSize, xSize, 0.05f, 0.05f, 0.3333333333333333);
        this.biomeJitter = this.noise9.func_4112_a(this.biomeJitter, xChunk, zChunk, xSize, xSize, 0.25, 0.25, 0.5882352941176471);
        int i = 0;
        for (int k = 0; k < xSize; ++k) {
            for (int l = 0; l < zSize; ++l) {
                double d9 = this.biomeJitter[i] * 1.1 + 0.5;
                double weightTemp = 0.01;
                double tempValue = (this.temperature[i] * 0.15 + 0.7) * (1.0 - weightTemp) + d9 * weightTemp;
                double weightHumid = 0.002;
                double humidValue = (this.humidity[i] * 0.15 + 0.5) * (1.0 - weightHumid) + d9 * weightHumid;
                tempValue = 1.0 - (1.0 - tempValue) * (1.0 - tempValue);
                tempValue = class_3532.method_15350((double)tempValue, (double)0.0, (double)1.0);
                humidValue = class_3532.method_15350((double)humidValue, (double)0.0, (double)1.0);
                this.temperature[i] = tempValue;
                this.humidity[i] = humidValue;
                biomes[i++] = BiomeGenBase.getBiomeFromLookup(tempValue, humidValue);
            }
        }
        return biomes;
    }
}

