/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.cabbagebeta.gen.beta;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cyborgcabbage.cabbagebeta.gen.BetaProperties;
import cyborgcabbage.cabbagebeta.gen.beta.BetaChunkProvider;
import cyborgcabbage.cabbagebeta.gen.beta.BetaOverworldBiomeSource;
import cyborgcabbage.cabbagebeta.gen.beta.BetaSeed;
import cyborgcabbage.cabbagebeta.gen.beta.ChunkProviderGenerate;
import cyborgcabbage.cabbagebeta.gen.beta.ChunkProviderHell;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3485;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_6748;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import net.minecraft.class_7138;

public class BetaChunkGenerator
extends class_2794 {
    public static final Codec<BetaChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_37227).forGetter(chunkGenerator -> chunkGenerator.field_37053), (App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(generator -> generator.biomeRegistry), (App)Codec.STRING.fieldOf("mode").orElse((Object)"").forGetter(BetaChunkGenerator::getDimensionMode), (App)Codec.BOOL.fieldOf("use_full_height").orElse((Object)false).forGetter(b -> b.prop.useFullHeight()), (App)Codec.INT.fieldOf("sea_level").orElse((Object)64).forGetter(b -> b.prop.seaLevel()), (App)Codec.FLOAT.fieldOf("factor").orElse((Object)Float.valueOf(12.0f)).forGetter(b -> Float.valueOf(b.prop.factor())), (App)Codec.INT.fieldOf("ground_level").orElse((Object)68).forGetter(b -> b.prop.groundLevel()), (App)Codec.INT.fieldOf("cave_lava_level").orElse((Object)10).forGetter(b -> b.prop.caveLavaLevel()), (App)Codec.FLOAT.fieldOf("mixing").orElse((Object)Float.valueOf(1.0f)).forGetter(b -> Float.valueOf(b.prop.mixing())), (App)Codec.BOOL.fieldOf("fixes").orElse((Object)false).forGetter(b -> b.prop.fixes())).apply((Applicative)instance, instance.stable(BetaChunkGenerator::new)));
    private final class_2378<class_1959> biomeRegistry;
    private final BetaSeed SEED_YOGSCAST = new BetaSeed(4090136037452000329L);
    private final BetaSeed SEED_STAMPY = new BetaSeed(6644803604819148923L);
    private final BetaSeed SEED_ANTVENOM = new BetaSeed(3811868026651017821L);
    private final BetaSeed SEED_PACK_PNG = new BetaSeed(3257840388504953787L);
    private final BetaSeed SEED_PANORAMA = new BetaSeed(2151901553968352745L);
    private String dimensionMode = "";
    protected BetaChunkProvider generator;
    private final BetaProperties prop;

    public String getDimensionMode() {
        return this.dimensionMode;
    }

    public static long toSeed(String seedString) {
        if (seedString != null && !seedString.isEmpty()) {
            try {
                return Long.parseLong(seedString);
            }
            catch (NumberFormatException numberFormatException7) {
                return seedString.hashCode();
            }
        }
        return new Random().nextLong();
    }

    public BetaChunkGenerator(class_2378<class_7059> structureSetRegistry, class_2378<class_1959> biomeRegistry, String dimensionMode, boolean useFullHeight, int seaLevel, float factor, int groundLevel, int caveLavaLevel, float mixing, boolean fixes) {
        super(structureSetRegistry, Optional.empty(), (class_1966)new BetaOverworldBiomeSource(biomeRegistry));
        this.biomeRegistry = biomeRegistry;
        this.dimensionMode = dimensionMode;
        this.prop = new BetaProperties(useFullHeight, seaLevel, factor, groundLevel, caveLavaLevel, mixing, fixes);
        this.generator = Objects.equals(this.dimensionMode, "nether") ? new ChunkProviderHell() : new ChunkProviderGenerate(this.prop);
        class_1966 class_19662 = this.field_12761;
        if (class_19662 instanceof BetaOverworldBiomeSource) {
            BetaOverworldBiomeSource bobs = (BetaOverworldBiomeSource)class_19662;
            bobs.setGenerator(this.generator);
        }
    }

    public BetaChunkGenerator(class_2378<class_7059> structureSetRegistry, class_2378<class_1959> biomeRegistry, String dimensionMode, BetaProperties p) {
        this(structureSetRegistry, biomeRegistry, dimensionMode, p.useFullHeight(), p.seaLevel(), p.factor(), p.groundLevel(), p.caveLavaLevel(), p.mixing(), p.fixes());
    }

    public int method_16398() {
        return this.prop.seaLevel();
    }

    public BetaProperties getBetaProperties() {
        return this.prop;
    }

    public class_2378<class_1959> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        this.generator.init(world.method_8412());
        this.generator.populate(world, chunk);
    }

    public void method_16129(class_5455 registryManager, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk, class_3485 structureTemplateManager, long seed) {
        this.generator.init(seed);
        super.method_16129(registryManager, noiseConfig, structureAccessor, chunk, structureTemplateManager, seed);
    }

    public void method_16130(class_5281 world, class_5138 structureAccessor, class_2791 chunk) {
        this.generator.init(world.method_8412());
        super.method_16130(world, structureAccessor, chunk);
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public void method_12107(class_3233 region) {
    }

    public int method_12104() {
        return 256;
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        this.generator.init(noiseConfig.method_42369());
        this.generator.fillChunk(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    public int method_33730() {
        return 0;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        return 64;
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        return new class_4966(world.method_31607(), Collections.nCopies(64, class_2246.field_10340.method_9564()).toArray(new class_2680[0]));
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }
}

