/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.cabbagebeta.gen.beta;

import cyborgcabbage.cabbagebeta.gen.BetaProperties;
import cyborgcabbage.cabbagebeta.gen.beta.BetaBiomes;
import cyborgcabbage.cabbagebeta.gen.beta.BetaBiomesSampler;
import cyborgcabbage.cabbagebeta.gen.beta.BetaChunkProvider;
import cyborgcabbage.cabbagebeta.gen.beta.biome.BiomeGenBase;
import cyborgcabbage.cabbagebeta.gen.beta.map.MapGenBase;
import cyborgcabbage.cabbagebeta.gen.beta.map.MapGenCaves;
import cyborgcabbage.cabbagebeta.gen.beta.noise.NoiseGeneratorOctaves;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenCactus;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenClay;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenDeadBush;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenDungeons;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenFlowers;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenLakes;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenLiquids;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenMinable;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenPumpkin;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenReed;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenTallGrass;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenerator;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3614;
import net.minecraft.class_5281;

public class ChunkProviderGenerate
extends BetaChunkProvider {
    private NoiseGeneratorOctaves noise16a;
    private NoiseGeneratorOctaves noise16b;
    private NoiseGeneratorOctaves noise8a;
    private NoiseGeneratorOctaves noise4a;
    private NoiseGeneratorOctaves noise4b;
    private NoiseGeneratorOctaves noise10a;
    private NoiseGeneratorOctaves noise16c;
    private NoiseGeneratorOctaves treeNoise;
    private double[] terrainNoiseValues;
    private double[] sandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] stoneNoise = new double[256];
    double[] highFreq3d8;
    double[] lowFreq3d16a;
    double[] lowFreq3d16b;
    double[] highFreq2d10;
    double[] lowFreq2d16;
    private double[] generatedTemperatures;
    protected final MapGenBase caveGen;
    private BetaBiomes terrainBiomes;
    private BetaBiomesSampler externalBiomes;
    private final BetaProperties prop;

    public ChunkProviderGenerate(BetaProperties properties) {
        this.prop = properties;
        this.caveGen = new MapGenCaves(properties.caveLavaLevel());
    }

    @Override
    protected void init(long seed) {
        if (this.rand != null) {
            return;
        }
        super.init(seed);
        this.terrainBiomes = new BetaBiomes(seed);
        this.externalBiomes = new BetaBiomesSampler(seed);
        this.noise16a = new NoiseGeneratorOctaves(this.rand, 16);
        this.noise16b = new NoiseGeneratorOctaves(this.rand, 16);
        this.noise8a = new NoiseGeneratorOctaves(this.rand, 8);
        this.noise4a = new NoiseGeneratorOctaves(this.rand, 4);
        this.noise4b = new NoiseGeneratorOctaves(this.rand, 4);
        this.noise10a = new NoiseGeneratorOctaves(this.rand, 10);
        this.noise16c = new NoiseGeneratorOctaves(this.rand, 16);
        this.treeNoise = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void generateTerrain(class_2791 chunk) {
        class_1923 pos = chunk.method_12004();
        int horizontalNoiseSize = 4;
        int xNoiseSize = horizontalNoiseSize + 1;
        int yNoiseSize = this.getHeight() / 8 + 1;
        int zNoiseSize = horizontalNoiseSize + 1;
        this.terrainNoiseValues = this.generateTerrainNoise(this.terrainNoiseValues, pos.field_9181 * horizontalNoiseSize, 0, pos.field_9180 * horizontalNoiseSize, xNoiseSize, yNoiseSize, zNoiseSize);
        class_2338.class_2339 blockPos = new class_2338.class_2339(0, 0, 0);
        for (int xNoiseIndex = 0; xNoiseIndex < horizontalNoiseSize; ++xNoiseIndex) {
            for (int zNoiseIndex = 0; zNoiseIndex < horizontalNoiseSize; ++zNoiseIndex) {
                for (int yNoiseIndex = 0; yNoiseIndex < this.getHeight() / 8; ++yNoiseIndex) {
                    double yFrac = 0.125;
                    double v000 = this.terrainNoiseValues[((xNoiseIndex + 0) * zNoiseSize + zNoiseIndex + 0) * yNoiseSize + yNoiseIndex + 0];
                    double v010 = this.terrainNoiseValues[((xNoiseIndex + 0) * zNoiseSize + zNoiseIndex + 1) * yNoiseSize + yNoiseIndex + 0];
                    double v100 = this.terrainNoiseValues[((xNoiseIndex + 1) * zNoiseSize + zNoiseIndex + 0) * yNoiseSize + yNoiseIndex + 0];
                    double v110 = this.terrainNoiseValues[((xNoiseIndex + 1) * zNoiseSize + zNoiseIndex + 1) * yNoiseSize + yNoiseIndex + 0];
                    double v001 = (this.terrainNoiseValues[((xNoiseIndex + 0) * zNoiseSize + zNoiseIndex + 0) * yNoiseSize + yNoiseIndex + 1] - v000) * yFrac;
                    double v011 = (this.terrainNoiseValues[((xNoiseIndex + 0) * zNoiseSize + zNoiseIndex + 1) * yNoiseSize + yNoiseIndex + 1] - v010) * yFrac;
                    double v101 = (this.terrainNoiseValues[((xNoiseIndex + 1) * zNoiseSize + zNoiseIndex + 0) * yNoiseSize + yNoiseIndex + 1] - v100) * yFrac;
                    double v111 = (this.terrainNoiseValues[((xNoiseIndex + 1) * zNoiseSize + zNoiseIndex + 1) * yNoiseSize + yNoiseIndex + 1] - v110) * yFrac;
                    for (int ySub = 0; ySub < 8; ++ySub) {
                        blockPos.method_33098(yNoiseIndex * 8 + ySub);
                        double xFrac = 0.25;
                        double d35 = v000;
                        double d37 = v010;
                        double d39 = (v100 - v000) * xFrac;
                        double d41 = (v110 - v010) * xFrac;
                        for (int xSub = 0; xSub < 4; ++xSub) {
                            blockPos.method_33097(xNoiseIndex * 4 + xSub);
                            double zFrac = 0.25;
                            double density = d35;
                            double zNoiseStep = (d37 - d35) * zFrac;
                            for (int zSub = 0; zSub < 4; ++zSub) {
                                blockPos.method_33099(zNoiseIndex * 4 + zSub);
                                double d53 = this.terrainBiomes.temperature[(xNoiseIndex * 4 + xSub) * 16 + zNoiseIndex * 4 + zSub];
                                class_2248 blockState = class_2246.field_10124;
                                if (yNoiseIndex * 8 + ySub < this.prop.seaLevel()) {
                                    blockState = d53 < 0.5 && yNoiseIndex * 8 + ySub >= this.prop.seaLevel() - 1 ? class_2246.field_10295 : class_2246.field_10382;
                                }
                                if (density > 0.0) {
                                    blockState = class_2246.field_10340;
                                }
                                chunk.method_12010((class_2338)blockPos, blockState.method_9564(), false);
                                density += zNoiseStep;
                            }
                            d35 += d39;
                            d37 += d41;
                        }
                        v000 += v001;
                        v010 += v011;
                        v100 += v101;
                        v110 += v111;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(class_2791 chunk, BiomeGenBase[] biomeGenBase4) {
        class_1923 pos = chunk.method_12004();
        double scale = 0.03125;
        if (this.prop.fixes()) {
            this.sandNoise = this.noise4a.generateNoiseOctaves(this.sandNoise, pos.field_9181 * 16, 0.0, pos.field_9180 * 16, 16, 1, 16, scale, 1.0, scale);
            this.gravelNoise = this.noise4a.generateNoiseOctaves(this.gravelNoise, pos.field_9181 * 16, 109.0134, pos.field_9180 * 16, 16, 1, 16, scale, 1.0, scale);
            this.stoneNoise = this.noise4b.generateNoiseOctaves(this.stoneNoise, pos.field_9181 * 16, 0.0, pos.field_9180 * 16, 16, 1, 16, scale * 2.0, scale * 2.0, scale * 2.0);
        } else {
            this.sandNoise = this.noise4a.generateNoiseOctaves(this.sandNoise, pos.field_9181 * 16, pos.field_9180 * 16, 0.0, 16, 16, 1, scale, scale, 1.0);
            this.gravelNoise = this.noise4a.generateNoiseOctaves(this.gravelNoise, pos.field_9181 * 16, 109.0134, pos.field_9180 * 16, 16, 1, 16, scale, 1.0, scale);
            this.stoneNoise = this.noise4b.generateNoiseOctaves(this.stoneNoise, pos.field_9181 * 16, pos.field_9180 * 16, 0.0, 16, 16, 1, scale * 2.0, scale * 2.0, scale * 2.0);
        }
        class_2338.class_2339 blockPos = new class_2338.class_2339(0, 0, 0);
        for (int h1 = 0; h1 < 16; ++h1) {
            blockPos.method_33099(h1);
            for (int h2 = 0; h2 < 16; ++h2) {
                blockPos.method_33097(h2);
                BiomeGenBase biomeGenBase10 = biomeGenBase4[h1 + h2 * 16];
                boolean sand = this.sandNoise[h1 + h2 * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean gravel = this.gravelNoise[h1 + h2 * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int stone = (int)(this.stoneNoise[h1 + h2 * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i14 = -1;
                class_2680 topBlock = biomeGenBase10.topBlock;
                class_2680 fillerBlock = biomeGenBase10.fillerBlock;
                for (int yBlock = this.getHeight() - 1; yBlock >= 0; --yBlock) {
                    blockPos.method_33098(yBlock);
                    class_2680 block = null;
                    if (yBlock <= this.rand.nextInt(5)) {
                        block = class_2246.field_9987.method_9564();
                    } else {
                        class_2680 state = chunk.method_8320((class_2338)blockPos);
                        if (state.method_26215()) {
                            i14 = -1;
                        } else if (state.method_27852(class_2246.field_10340)) {
                            if (i14 == -1) {
                                if (stone <= 0) {
                                    topBlock = class_2246.field_10124.method_9564();
                                    fillerBlock = class_2246.field_10340.method_9564();
                                } else if (yBlock >= this.prop.seaLevel() - 4 && yBlock <= this.prop.seaLevel() + 1) {
                                    topBlock = biomeGenBase10.topBlock;
                                    fillerBlock = biomeGenBase10.fillerBlock;
                                    if (gravel) {
                                        topBlock = class_2246.field_10124.method_9564();
                                        fillerBlock = class_2246.field_10255.method_9564();
                                    }
                                    if (sand) {
                                        topBlock = class_2246.field_10102.method_9564();
                                        fillerBlock = class_2246.field_10102.method_9564();
                                    }
                                }
                                if (yBlock < this.prop.seaLevel() && topBlock == class_2246.field_10124.method_9564()) {
                                    topBlock = class_2246.field_10382.method_9564();
                                }
                                i14 = stone;
                                block = yBlock >= this.prop.seaLevel() - 1 ? topBlock : fillerBlock;
                            } else if (i14 > 0) {
                                block = fillerBlock;
                                if (--i14 == 0 && fillerBlock == class_2246.field_10102.method_9564()) {
                                    i14 = this.rand.nextInt(4);
                                    fillerBlock = class_2246.field_9979.method_9564();
                                }
                            }
                        }
                    }
                    if (block == null) continue;
                    chunk.method_12010((class_2338)blockPos, block, false);
                }
            }
        }
    }

    @Override
    public void fillChunk(class_2791 chunk) {
        class_1923 pos = chunk.method_12004();
        this.rand.setSeed((long)pos.field_9181 * 341873128712L + (long)pos.field_9180 * 132897987541L);
        this.terrainBiomes.biomes = this.terrainBiomes.generateBiomes(this.terrainBiomes.biomes, pos.field_9181 * 16, pos.field_9180 * 16, 16, 16);
        this.generateTerrain(chunk);
        this.replaceBlocksForBiome(chunk, this.terrainBiomes.biomes);
        this.caveGen.generate(chunk, this.worldSeed);
    }

    private double[] generateTerrainNoise(double[] noiseArray, int xOffset, int yOffset, int zOffset, int xNoiseSize, int yNoiseSize, int zNoiseSize) {
        if (noiseArray == null) {
            noiseArray = new double[xNoiseSize * yNoiseSize * zNoiseSize];
        }
        double hScale = 684.412;
        double vScale = 684.412;
        double[] temp = this.terrainBiomes.temperature;
        double[] humidity = this.terrainBiomes.humidity;
        this.highFreq2d10 = this.noise10a.func_4109_a(this.highFreq2d10, xOffset, zOffset, xNoiseSize, zNoiseSize, 1.121, 1.121, 0.5);
        this.lowFreq2d16 = this.noise16c.func_4109_a(this.lowFreq2d16, xOffset, zOffset, xNoiseSize, zNoiseSize, 200.0, 200.0, 0.5);
        this.highFreq3d8 = this.noise8a.generateNoiseOctaves(this.highFreq3d8, xOffset, yOffset, zOffset, xNoiseSize, yNoiseSize, zNoiseSize, hScale / 80.0, vScale / 160.0, hScale / 80.0);
        this.lowFreq3d16a = this.noise16a.generateNoiseOctaves(this.lowFreq3d16a, xOffset, yOffset, zOffset, xNoiseSize, yNoiseSize, zNoiseSize, hScale, vScale, hScale);
        this.lowFreq3d16b = this.noise16b.generateNoiseOctaves(this.lowFreq3d16b, xOffset, yOffset, zOffset, xNoiseSize, yNoiseSize, zNoiseSize, hScale, vScale, hScale);
        int noiseIndex = 0;
        int noiseIndex2 = 0;
        int samplePeriod = 16 / xNoiseSize;
        for (int xNoiseIndex = 0; xNoiseIndex < xNoiseSize; ++xNoiseIndex) {
            int xSample;
            if (this.prop.fixes()) {
                xSample = xNoiseIndex * 4;
                if (xSample > 15) {
                    xSample = 15;
                }
            } else {
                xSample = xNoiseIndex * samplePeriod + samplePeriod / 2;
            }
            for (int zNoiseIndex = 0; zNoiseIndex < zNoiseSize; ++zNoiseIndex) {
                double lowFreq2d3;
                int zSample;
                if (this.prop.fixes()) {
                    zSample = zNoiseIndex * 4;
                    if (zSample > 15) {
                        zSample = 15;
                    }
                } else {
                    zSample = zNoiseIndex * samplePeriod + samplePeriod / 2;
                }
                double tempVal = temp[xSample * 16 + zSample];
                double humidityVal = humidity[xSample * 16 + zSample] * tempVal;
                humidityVal = 1.0 - humidityVal;
                humidityVal *= humidityVal;
                humidityVal *= humidityVal;
                humidityVal = 1.0 - humidityVal;
                double highFreqHumid = (this.highFreq2d10[noiseIndex2] + 256.0) / 512.0;
                if ((highFreqHumid *= humidityVal) > 1.0) {
                    highFreqHumid = 1.0;
                }
                if ((lowFreq2d3 = this.lowFreq2d16[noiseIndex2] / 8000.0) < 0.0) {
                    lowFreq2d3 = -lowFreq2d3 * 0.3;
                }
                if ((lowFreq2d3 = lowFreq2d3 * 3.0 - 2.0) < 0.0) {
                    if ((lowFreq2d3 /= 2.0) < -1.0) {
                        lowFreq2d3 = -1.0;
                    }
                    lowFreq2d3 /= 1.4;
                    lowFreq2d3 /= 2.0;
                    highFreqHumid = 0.0;
                } else {
                    if (lowFreq2d3 > 1.0) {
                        lowFreq2d3 = 1.0;
                    }
                    lowFreq2d3 /= 8.0;
                }
                if (highFreqHumid < 0.0) {
                    highFreqHumid = 0.0;
                }
                highFreqHumid += 0.5;
                lowFreq2d3 = lowFreq2d3 * 17.0 / 16.0;
                double groundLevelLocal = (double)this.prop.groundLevel() / 8.0 + lowFreq2d3 * 4.0;
                ++noiseIndex2;
                for (int yNoiseIndex = 0; yNoiseIndex < yNoiseSize; ++yNoiseIndex) {
                    double bias = ((double)yNoiseIndex - groundLevelLocal) * (double)this.prop.factor() / highFreqHumid;
                    if (bias < 0.0) {
                        bias *= 4.0;
                    }
                    double a = this.lowFreq3d16a[noiseIndex] / 512.0;
                    double b = this.lowFreq3d16b[noiseIndex] / 512.0;
                    double mix = this.highFreq3d8[noiseIndex] / 20.0 * (double)this.prop.mixing() + 0.5;
                    double noiseValue = mix < 0.0 ? a : (mix > 1.0 ? b : a + (b - a) * mix);
                    noiseValue -= bias;
                    if (yNoiseIndex > yNoiseSize - 4) {
                        double d44 = (float)(yNoiseIndex - (yNoiseSize - 4)) / 3.0f;
                        noiseValue = noiseValue * (1.0 - d44) + -10.0 * d44;
                    }
                    noiseArray[noiseIndex] = noiseValue;
                    ++noiseIndex;
                }
            }
        }
        return noiseArray;
    }

    @Override
    public void populate(class_5281 world, class_2791 chunk) {
        int i2 = chunk.method_12004().field_9181;
        int i3 = chunk.method_12004().field_9180;
        int chunkX = i2 * 16;
        int chunkZ = i3 * 16;
        WorldGeneratorContext context = new WorldGeneratorContext(world, chunkX, chunkZ);
        BiomeGenBase biome = this.terrainBiomes.getBiomeAtBlock(chunkX + 16, chunkZ + 16);
        this.rand.setSeed(this.worldSeed);
        long j7 = this.rand.nextLong() / 2L * 2L + 1L;
        long j9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)i2 * j7 + (long)i3 * j9 ^ this.worldSeed);
        this.generateFeatureRare(context, new WorldGenLakes(class_2246.field_10382.method_9564()), 4);
        if (this.rand.nextInt(8) == 0) {
            int i13 = chunkX + this.rand.nextInt(16) + 8;
            int i14 = this.rand.nextInt(this.rand.nextInt(this.getHeight() - 8) + 8);
            int i15 = chunkZ + this.rand.nextInt(16) + 8;
            if (i14 < 64 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(class_2246.field_10164.method_9564()).generate(world, this.rand, i13, i14, i15);
            }
        }
        this.generateFeature(context, new WorldGenDungeons(), 8, true);
        this.generateFeature(context, new WorldGenClay(32), 10, false);
        this.generateMineable(context, class_2246.field_10566.method_9564(), 32, this.getHeight(), 20);
        this.generateMineable(context, class_2246.field_10255.method_9564(), 32, this.getHeight(), 10);
        this.generateMineable(context, class_2246.field_10418.method_9564(), 16, this.getHeight(), 20);
        this.generateMineable(context, class_2246.field_10212.method_9564(), 8, 64, 20);
        this.generateMineable(context, class_2246.field_10571.method_9564(), 8, 32, 2);
        this.generateMineable(context, class_2246.field_10080.method_9564(), 7, 16, 8);
        this.generateMineable(context, class_2246.field_10442.method_9564(), 7, 16, 1);
        this.generateMineableBinomial(context, class_2246.field_10090.method_9564(), 6, 16, 1);
        double d11 = 0.5;
        int extraTrees = (int)((this.treeNoise.func_806_a((double)chunkX * d11, (double)chunkZ * d11) / 8.0 + this.rand.nextDouble() * 4.0 + 4.0) / 3.0);
        int treeCount = 0;
        if (this.rand.nextInt(10) == 0) {
            ++treeCount;
        }
        if (biome.addExtraTrees) {
            treeCount += extraTrees;
        }
        treeCount += biome.treeCount;
        for (int i = 0; i < treeCount; ++i) {
            int x = chunkX + this.rand.nextInt(16) + 8;
            int z = chunkZ + this.rand.nextInt(16) + 8;
            WorldGenerator generator = biome.getRandomWorldGenForTrees(this.rand, this.getHeight());
            generator.func_517_a(1.0, 1.0, 1.0);
            generator.generate(world, this.rand, x, world.method_8624(class_2902.class_2903.field_13202, x, z), z);
        }
        this.generateFeature(context, new WorldGenFlowers(class_2246.field_10182.method_9564()), biome.dandelionCount, true);
        for (int i17 = 0; i17 < biome.shrubCount; ++i17) {
            int b26 = 1;
            if (biome == BiomeGenBase.rainforest && this.rand.nextInt(3) != 0) {
                b26 = 2;
            }
            int i19 = chunkX + this.rand.nextInt(16) + 8;
            int i20 = this.rand.nextInt(this.getHeight());
            int i21 = chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenTallGrass(b26 == 1 ? class_2246.field_10479.method_9564() : class_2246.field_10112.method_9564()).generate(world, this.rand, i19, i20, i21);
        }
        if (biome == BiomeGenBase.desert) {
            this.generateFeature(context, new WorldGenDeadBush(class_2246.field_10428.method_9564()), 2, true);
        }
        this.generateFeatureRare(context, new WorldGenFlowers(class_2246.field_10449.method_9564()), 2);
        this.generateFeatureRare(context, new WorldGenFlowers(class_2246.field_10251.method_9564()), 4);
        this.generateFeatureRare(context, new WorldGenFlowers(class_2246.field_10559.method_9564()), 8);
        this.generateFeature(context, new WorldGenReed(), 10, true);
        this.generateFeatureRare(context, new WorldGenPumpkin(), 32);
        if (biome == BiomeGenBase.desert) {
            this.generateFeature(context, new WorldGenCactus(), 10, true);
        }
        this.generateFeature(context, new WorldGenLiquids(class_2246.field_10382.method_9564()), 50, true, r -> r.nextInt(r.nextInt(this.getHeight() - 8) + 8));
        this.generateFeature(context, new WorldGenLiquids(class_2246.field_10164.method_9564()), 20, true, r -> r.nextInt(r.nextInt(r.nextInt(this.getHeight() - 16) + 8) + 8));
        this.generatedTemperatures = this.terrainBiomes.getTemperatures(this.generatedTemperatures, chunkX + 8, chunkZ + 8, 16, 16);
        for (int x = chunkX + 8; x < chunkX + 8 + 16; ++x) {
            for (int z = chunkZ + 8; z < chunkZ + 8 + 16; ++z) {
                int relX = x - (chunkX + 8);
                int relZ = z - (chunkZ + 8);
                int surfaceY = world.method_8624(class_2902.class_2903.field_13197, x, z);
                double temperature = this.generatedTemperatures[relX * 16 + relZ] - (double)(surfaceY - 64) / 64.0 * 0.3;
                class_2338.class_2339 blockPosTop = new class_2338.class_2339(x, surfaceY, z);
                class_2680 stateBelow = world.method_8320(blockPosTop.method_10074());
                if (!(temperature < 0.5) || surfaceY <= 0 || surfaceY >= this.getHeight() || !world.method_22347((class_2338)blockPosTop) || !stateBelow.method_26207().method_15799() || stateBelow.method_26207() == class_3614.field_15958) continue;
                world.method_8652((class_2338)blockPosTop, class_2246.field_10477.method_9564(), 3);
                class_2246.field_10477.method_9564().method_30101((class_1936)world, (class_2338)blockPosTop, 3);
            }
        }
    }

    private void generateFeature(WorldGeneratorContext context, WorldGenerator generator, int count, boolean offset) {
        this.generateFeature(context, generator, count, offset, r -> r.nextInt(this.getHeight()));
    }

    private void generateFeature(WorldGeneratorContext context, WorldGenerator generator, int count, boolean offset, GenerateCoordinate generateCoordinate) {
        for (int r = 0; r < count; ++r) {
            int x = context.x() + this.rand.nextInt(16) + (offset ? 8 : 0);
            int y = generateCoordinate.gen(this.rand);
            int z = context.z() + this.rand.nextInt(16) + (offset ? 8 : 0);
            generator.generate(context.world(), this.rand, x, y, z);
        }
    }

    private void generateFeatureRare(WorldGeneratorContext context, WorldGenerator generator, int scarcity) {
        if (this.rand.nextInt(scarcity) == 0) {
            int x = context.x() + this.rand.nextInt(16) + 8;
            int y = this.rand.nextInt(this.getHeight());
            int z = context.z() + this.rand.nextInt(16) + 8;
            generator.generate(context.world(), this.rand, x, y, z);
        }
    }

    private void generateMineable(WorldGeneratorContext context, class_2680 block, int veinSize, int bound, int count) {
        for (int r = 0; r < count; ++r) {
            int x = context.x() + this.rand.nextInt(16);
            int y = this.rand.nextInt(bound);
            int z = context.z() + this.rand.nextInt(16);
            new WorldGenMinable(block, veinSize).generate(context.world(), this.rand, x, y, z);
        }
    }

    private void generateMineableBinomial(WorldGeneratorContext context, class_2680 block, int veinSize, int bound, int count) {
        for (int r = 0; r < count; ++r) {
            int x = context.x() + this.rand.nextInt(16);
            int y = this.rand.nextInt(bound) + this.rand.nextInt(bound);
            int z = context.z() + this.rand.nextInt(16);
            new WorldGenMinable(block, veinSize).generate(context.world(), this.rand, x, y, z);
        }
    }

    @Override
    public BiomeGenBase getBiome(int x, int z) {
        return this.externalBiomes.getBiomeAtBlock(x, z);
    }

    public int getHeight() {
        return this.prop.useFullHeight() ? 256 : 128;
    }

    record WorldGeneratorContext(class_5281 world, int x, int z) {
    }

    static interface GenerateCoordinate {
        public int gen(Random var1);
    }
}

