/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.cabbagebeta.gen.beta.biome;

import cyborgcabbage.cabbagebeta.gen.beta.biome.BiomeGenDesert;
import cyborgcabbage.cabbagebeta.gen.beta.biome.BiomeGenForest;
import cyborgcabbage.cabbagebeta.gen.beta.biome.BiomeGenHell;
import cyborgcabbage.cabbagebeta.gen.beta.biome.BiomeGenRainforest;
import cyborgcabbage.cabbagebeta.gen.beta.biome.BiomeGenSky;
import cyborgcabbage.cabbagebeta.gen.beta.biome.BiomeGenSwamp;
import cyborgcabbage.cabbagebeta.gen.beta.biome.BiomeGenTaiga;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenBigOak;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenOak;
import cyborgcabbage.cabbagebeta.gen.beta.worldgen.WorldGenerator;
import java.awt.Color;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_4763;
import net.minecraft.class_5478;
import net.minecraft.class_5483;
import net.minecraft.class_5485;

public class BiomeGenBase {
    public static final BiomeGenBase rainforest = new BiomeGenRainforest().setColor(588342).setBiomeName("Rainforest").setOtherColor(2094168).setTemperature(0.99f).setHumidity(0.98f).setTrees(true, 5).setShrubs(10);
    public static final BiomeGenBase swampland = new BiomeGenSwamp().setColor(522674).setBiomeName("Swampland").setOtherColor(9154376).setTemperature(0.64f).setHumidity(0.93f);
    public static final BiomeGenBase seasonalForest = new BiomeGenBase().setColor(10215459).setBiomeName("Seasonal Forest").setTemperature(0.99f).setHumidity(0.68f).setTrees(true, 2).setDandelions(4).setShrubs(2);
    public static final BiomeGenBase forest = new BiomeGenForest().setColor(353825).setBiomeName("Forest").setOtherColor(5159473).setTemperature(0.87f).setHumidity(0.71f).setTrees(true, 5).setDandelions(2).setShrubs(2);
    public static final BiomeGenBase savanna = new BiomeGenDesert().setColor(14278691).setBiomeName("Savanna").setTemperature(0.77f).setHumidity(0.11f);
    public static final BiomeGenBase shrubland = new BiomeGenBase().setColor(10595616).setBiomeName("Shrubland").setTemperature(0.8f).setHumidity(0.37f);
    public static final BiomeGenBase taiga = new BiomeGenTaiga().setColor(3060051).setBiomeName("Taiga").setEnableSnow().setOtherColor(8107825).setTemperature(0.41f).setHumidity(0.78f).setTrees(true, 5).setDandelions(2).setShrubs(1);
    public static final BiomeGenBase desert = new BiomeGenDesert().setColor(16421912).setBiomeName("Desert").setDisableRain().setTemperature(0.98f).setHumidity(0.08f).setTrees(false, -20);
    public static final BiomeGenBase plains = new BiomeGenDesert().setColor(16767248).setBiomeName("Plains").setTemperature(0.99f).setHumidity(0.34f).setTrees(false, -20).setDandelions(3).setShrubs(10);
    public static final BiomeGenBase iceDesert = new BiomeGenDesert().setColor(16772499).setBiomeName("Ice Desert").setEnableSnow().setDisableRain().setOtherColor(12899129).setTemperature(0.4f).setHumidity(0.2f);
    public static final BiomeGenBase tundra = new BiomeGenBase().setColor(5762041).setBiomeName("Tundra").setEnableSnow().setOtherColor(12899129).setTemperature(0.26f).setHumidity(0.37f).setTrees(false, -20);
    public static final BiomeGenBase hell = new BiomeGenHell().setColor(0xFF0000).setBiomeName("Hell").setDisableRain().setTemperature(1.0f).setHumidity(0.0f);
    public static final BiomeGenBase sky = new BiomeGenSky().setColor(0x8080FF).setBiomeName("Sky").setDisableRain().setTemperature(0.99f).setHumidity(0.34f);
    public String biomeName;
    public int color;
    public class_2680 topBlock = class_2246.field_10219.method_9564();
    public class_2680 fillerBlock = class_2246.field_10566.method_9564();
    public int otherColor = 5169201;
    private boolean enableSnow;
    private boolean enableRain = true;
    private static final BiomeGenBase[] biomeLookupTable = new BiomeGenBase[4096];
    public int id = biomeCount++;
    public static int biomeCount = 0;
    private float temperature = 0.5f;
    private float humidity = 0.5f;
    public boolean addExtraTrees = false;
    public int treeCount = 0;
    public int dandelionCount = 0;
    public int shrubCount = 0;

    protected BiomeGenBase() {
    }

    public class_1959 createModernBiome() {
        return new class_1959.class_1960().method_8735(this.enableSnow ? class_1959.class_1963.field_9383 : (this.enableRain ? class_1959.class_1963.field_9382 : class_1959.class_1963.field_9384)).method_8747(this.temperature).method_8727(this.humidity).method_24379(this.getBiomeEffects().method_24391()).method_30974(this.getSpawnSettings().method_31007()).method_30973(new class_5485.class_5495().method_30987()).method_30972();
    }

    protected class_4763.class_4764 getBiomeEffects() {
        return new class_4763.class_4764().method_24395(3102975).method_24397(329011).method_24392(12638463).method_30820(class_5478.method_30932((float)this.temperature));
    }

    protected class_5483.class_5496 getSpawnSettings() {
        class_5483.class_5496 builder = new class_5483.class_5496();
        BiomeGenBase.addBetaMonsters(builder);
        BiomeGenBase.addBetaAnimals(builder);
        return builder;
    }

    private static void addBetaMonsters(class_5483.class_5496 builder) {
        builder.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6079, 100, 4, 4));
        builder.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6051, 100, 4, 4));
        builder.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6137, 100, 4, 4));
        builder.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6046, 100, 4, 4));
        builder.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6069, 100, 4, 4));
    }

    private static void addBetaAnimals(class_5483.class_5496 builder) {
        builder.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_6115, 12, 4, 4));
        builder.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_6093, 10, 4, 4));
        builder.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_6132, 10, 4, 4));
        builder.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_6085, 8, 4, 4));
        builder.method_31011(class_1311.field_6300, new class_5483.class_1964(class_1299.field_6114, 1, 1, 4));
    }

    private BiomeGenBase setDandelions(int dandelionCount) {
        this.dandelionCount = dandelionCount;
        return this;
    }

    private BiomeGenBase setShrubs(int shrubCount) {
        this.shrubCount = shrubCount;
        return this;
    }

    private BiomeGenBase setTrees(boolean addExtra, int treeCount) {
        this.addExtraTrees = addExtra;
        this.treeCount = treeCount;
        return this;
    }

    private BiomeGenBase setTemperature(float temp) {
        this.temperature = temp;
        return this;
    }

    private BiomeGenBase setHumidity(float humid) {
        this.humidity = humid;
        return this;
    }

    private BiomeGenBase setDisableRain() {
        this.enableRain = false;
        return this;
    }

    public static void generateBiomeLookup() {
        for (int t = 0; t < 64; ++t) {
            for (int h = 0; h < 64; ++h) {
                BiomeGenBase.biomeLookupTable[t + h * 64] = BiomeGenBase.getBiome((float)t / 63.0f, (float)h / 63.0f);
            }
        }
        BiomeGenBase.desert.topBlock = BiomeGenBase.desert.fillerBlock = class_2246.field_10102.method_9564();
        BiomeGenBase.iceDesert.topBlock = BiomeGenBase.iceDesert.fillerBlock = class_2246.field_10102.method_9564();
    }

    public WorldGenerator getRandomWorldGenForTrees(Random random1, int height) {
        return random1.nextInt(10) == 0 ? new WorldGenBigOak() : new WorldGenOak(height);
    }

    protected BiomeGenBase setEnableSnow() {
        this.enableSnow = true;
        return this;
    }

    protected BiomeGenBase setBiomeName(String string1) {
        this.biomeName = string1;
        return this;
    }

    protected BiomeGenBase setOtherColor(int i1) {
        this.otherColor = i1;
        return this;
    }

    protected BiomeGenBase setColor(int i1) {
        this.color = i1;
        return this;
    }

    public static BiomeGenBase getBiomeFromLookup(double d0, double d2) {
        int i4 = (int)(d0 * 63.0);
        int i5 = (int)(d2 * 63.0);
        return biomeLookupTable[i4 + i5 * 64];
    }

    public static BiomeGenBase getBiome(float f0, float f1) {
        return f0 < 0.1f ? tundra : (f1 < 0.2f ? (f0 < 0.5f ? tundra : (f0 < 0.95f ? savanna : desert)) : (f1 > 0.5f && f0 < 0.7f ? swampland : (f0 < 0.5f ? taiga : (f0 < 0.97f ? (f1 < 0.35f ? shrubland : forest) : (f1 < 0.45f ? plains : ((f1 *= f0) < 0.9f ? seasonalForest : rainforest))))));
    }

    public int getSkyColorByTemp(float f1) {
        if ((f1 /= 3.0f) < -1.0f) {
            f1 = -1.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        return Color.getHSBColor(0.62222224f - f1 * 0.05f, 0.5f + f1 * 0.1f, 1.0f).getRGB();
    }

    public boolean getEnableSnow() {
        return this.enableSnow;
    }

    public boolean canSpawnLightningBolt() {
        return this.enableRain && !this.enableSnow;
    }

    static {
        BiomeGenBase.generateBiomeLookup();
    }
}

