/*
 * Decompiled with CFR 0.152.
 */
package com.innky.majobroom.armors;

import com.innky.majobroom.jsonbean.GeomtryBean;
import com.innky.majobroom.utills.ModelJsonReader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class MajoWearableModel
extends HumanoidModel<LivingEntity> {
    public final ModelPart base;
    private final String model_name;
    private final Map<String, PartDefinition> bones = new HashMap<String, PartDefinition>();
    private final HashMap<String, GeomtryBean.BonesBean> bonesBean = new HashMap();

    public MajoWearableModel(String name) {
        super(HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f).m_171576_().m_171583_(256, 256));
        this.base = this.getTexturedModelData(name).m_171564_();
        this.model_name = name;
    }

    private float convertOrigin(GeomtryBean.BonesBean bones, GeomtryBean.BonesBean.CubesBean cubes, int index) {
        if (index == 1) {
            return bones.getPivot().get(index).floatValue() - cubes.getOrigin().get(index).floatValue() - cubes.getSize().get(index).floatValue();
        }
        return cubes.getOrigin().get(index).floatValue() - bones.getPivot().get(index).floatValue();
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        switch (this.model_name) {
            case "majo_hat": {
                this.base.m_104315_(this.f_102808_);
                break;
            }
            case "majo_cloth": {
                this.base.m_171324_("bigBody").m_104315_(this.f_102810_);
                this.base.m_171324_("epic").m_104315_(this.f_102810_);
                this.base.m_171324_("bone81").m_171324_("left").m_104315_(this.f_102811_);
                this.base.m_171324_("bone81").m_171324_("right").m_104315_(this.f_102812_);
                ModelPart dress = this.base.m_171324_("dress");
                dress.f_104203_ = (this.f_102814_.f_104203_ + this.f_102813_.f_104203_) / 2.0f;
                dress.f_104202_ = this.f_102814_.f_104202_;
                if (this.f_102609_) {
                    dress.f_104201_ = 10.0f;
                    dress.f_104203_ = -1.04f;
                    this.base.m_171324_((String)"bigBody").m_171324_((String)"bone3").m_171324_((String)"bone5").m_171324_((String)"sithide1").f_104207_ = false;
                    this.base.m_171324_((String)"bigBody").m_171324_((String)"bone3").m_171324_((String)"bone5").m_171324_((String)"sithide2").f_104207_ = false;
                    break;
                }
                dress.f_104201_ = 10.0f;
                this.base.m_171324_((String)"bigBody").m_171324_((String)"bone3").m_171324_((String)"bone5").m_171324_((String)"sithide1").f_104207_ = true;
                this.base.m_171324_((String)"bigBody").m_171324_((String)"bone3").m_171324_((String)"bone5").m_171324_((String)"sithide2").f_104207_ = true;
                break;
            }
            case "majo_boots": {
                this.base.m_171324_("LeftLeg").m_104315_(this.f_102814_);
                this.base.m_171324_("RightLeg").m_104315_(this.f_102813_);
            }
        }
        this.base.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public LayerDefinition getTexturedModelData(String path) {
        GeomtryBean model = ModelJsonReader.readJson("jsonmodels/" + path);
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        if (model != null) {
            for (GeomtryBean.BonesBean bone : model.getBones()) {
                CubeListBuilder newBone = CubeListBuilder.m_171558_();
                float x = 0.0f;
                float y = 0.0f;
                float z = 0.0f;
                if (bone.getRotation() != null) {
                    x = 0.017453f * bone.getRotation().get(0).floatValue();
                    y = 0.017453f * bone.getRotation().get(1).floatValue();
                    z = 0.017453f * bone.getRotation().get(2).floatValue();
                }
                if (bone.getCubes() != null) {
                    for (GeomtryBean.BonesBean.CubesBean cube : bone.getCubes()) {
                        newBone.m_171514_(cube.getUv().get(0).intValue(), cube.getUv().get(1).intValue()).m_171488_(this.convertOrigin(bone, cube, 0), this.convertOrigin(bone, cube, 1), this.convertOrigin(bone, cube, 2), cube.getSize().get(0).floatValue(), cube.getSize().get(1).floatValue(), cube.getSize().get(2).floatValue(), new CubeDeformation(cube.getInflate()));
                    }
                }
                PartDefinition nnnn = null;
                if (bone.getParent() != null) {
                    GeomtryBean.BonesBean parent = this.bonesBean.get(bone.getParent());
                    this.bones.get(bone.getParent()).m_171599_(bone.getName(), newBone, PartPose.m_171423_((float)(bone.getPivot().get(0).floatValue() - parent.getPivot().get(0).floatValue()), (float)(parent.getPivot().get(1).floatValue() - bone.getPivot().get(1).floatValue()), (float)(bone.getPivot().get(2).floatValue() - parent.getPivot().get(2).floatValue()), (float)x, (float)y, (float)z));
                    nnnn = this.bones.get(bone.getParent()).m_171597_(bone.getName());
                } else {
                    modelPartData.m_171599_(bone.getName(), newBone, PartPose.m_171423_((float)bone.getPivot().get(0).floatValue(), (float)(24.0f - bone.getPivot().get(1).floatValue()), (float)bone.getPivot().get(2).floatValue(), (float)x, (float)y, (float)z));
                    nnnn = modelPartData.m_171597_(bone.getName());
                }
                this.bones.put(bone.getName(), nnnn);
                this.bonesBean.put(bone.getName(), bone);
            }
        }
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)model.getTexturewidth(), (int)model.getTextureheight());
    }
}

