/*
 * Decompiled with CFR 0.152.
 */
package com.innky.majobroom.entity;

import com.innky.majobroom.armors.MajoWearableItem;
import com.innky.majobroom.events.KeyBoardInput;
import com.innky.majobroom.network.Networking;
import com.innky.majobroom.network.RidePack;
import com.innky.majobroom.registry.ItemRegistry;
import com.innky.majobroom.utills.Config;
import java.util.List;
import net.minecraft.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class MajoBroom
extends Boat {
    private float fl = 0.0f;
    private float serials = 0.0f;
    private float lastfl = 0.0f;
    private float playerSpeed = 0.9f;
    private boolean forward = false;
    private boolean backward = false;
    public boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean down = false;
    private static final EntityDataAccessor<Boolean> controlMode = SynchedEntityData.m_135353_(MajoBroom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> playerLevel = SynchedEntityData.m_135353_(MajoBroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> configSpeed = SynchedEntityData.m_135353_(MajoBroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> configAdvancedMode = SynchedEntityData.m_135353_(MajoBroom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean hasPassenger = false;
    public char summonParticle = '\u0000';
    private boolean hasMajoWearable;

    public MajoBroom(EntityType<? extends Boat> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(controlMode, (Object)false);
        this.f_19804_.m_135372_(playerLevel, (Object)0);
        this.f_19804_.m_135372_(configSpeed, (Object)100);
        this.f_19804_.m_135372_(configAdvancedMode, (Object)true);
        super.m_8097_();
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_19804_.m_135381_(controlMode, (Object)compound.m_128471_("controlMode"));
        this.f_19804_.m_135381_(playerLevel, (Object)compound.m_128451_("playerLevel"));
        super.m_7378_(compound);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("controlMode", ((Boolean)this.f_19804_.m_135370_(controlMode)).booleanValue());
        compound.m_128405_("playerLevel", ((Integer)this.f_19804_.m_135370_(playerLevel)).intValue());
        super.m_7380_(compound);
    }

    public boolean getControlMode() {
        return (Boolean)this.f_19804_.m_135370_(controlMode);
    }

    public void setControlMode(boolean controlMode) {
        this.f_19804_.m_135381_(MajoBroom.controlMode, (Object)controlMode);
    }

    private void superTick() {
        this.f_38280_ = this.f_38279_;
        this.f_38279_ = Boat.Status.IN_WATER;
        this.f_38265_ = 0.0f;
        if (this.m_38385_() > 0) {
            this.m_38354_(this.m_38385_() - 1);
        }
        if (this.m_38384_() > 0.0f) {
            this.m_38311_(this.m_38384_() - 1.0f);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_20115_(6, this.m_142038_());
        }
        this.m_6075_();
        this.m_38391_();
    }

    public void m_38395_() {
        double d1 = 0.0;
        if (this.m_20197_().isEmpty()) {
            d1 = -0.01f;
        }
        double momentum = this.playerSpeed;
        Vec3 vector3d = this.m_20184_();
        Vec3 v = new Vec3(vector3d.f_82479_ * momentum, vector3d.f_82480_ + d1, vector3d.f_82481_ * momentum);
        this.m_20256_(v);
        this.f_38266_ = (float)((double)this.f_38266_ * 0.85);
    }

    @NotNull
    public Item m_38369_() {
        return (Item)ItemRegistry.broomItem.get();
    }

    public void m_38396_() {
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.f_38273_) {
                this.f_38266_ -= 1.0f;
            }
            if (this.f_38274_) {
                this.f_38266_ += 1.0f;
            }
            if (this.f_38274_ != this.f_38273_ && !this.f_38275_ && !this.f_38276_) {
                f += 0.005f;
            }
            double percent = (double)((Integer)this.f_19804_.m_135370_(configSpeed)).intValue() / 100.0;
            this.f_19857_ += this.f_38266_;
            if (this.f_38275_) {
                f += 0.04f * this.playerSpeed * 2.0f;
            }
            if (this.f_38276_) {
                f -= 0.01f * this.playerSpeed * 4.0f;
            }
            Vec3 v3d = this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.f_19857_ * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(this.f_19857_ * ((float)Math.PI / 180))) * f));
            float currentY = (float)v3d.f_82480_;
            float maxYspeed = 0.3f * this.playerSpeed * 2.0f;
            float yacc = 0.05f * this.playerSpeed * 1.5f;
            float ydec = 0.02f;
            if (currentY > 0.0f) {
                if (!this.up || !this.down) {
                    currentY = this.up ? (currentY + yacc > maxYspeed ? maxYspeed : (currentY += yacc)) : (this.down ? (currentY -= yacc) : (currentY -= ydec));
                }
            } else if (!this.up || !this.down) {
                currentY = this.down ? (currentY - yacc < -maxYspeed ? -maxYspeed : (currentY -= yacc)) : (this.up ? (currentY += yacc) : (currentY += ydec));
            }
            if ((double)Math.abs(currentY) <= 0.03) {
                currentY = 0.0f;
            }
            this.m_20334_(v3d.f_82479_, currentY, v3d.f_82481_);
            this.m_38339_(this.f_38274_ && !this.f_38273_ || this.f_38275_, this.f_38273_ && !this.f_38274_ || this.f_38275_);
        }
    }

    public void collision() {
        this.m_20101_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.f_19853_.f_46443_ && !(this.m_6688_() instanceof Player);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.m_20363_((Entity)this)) continue;
                if (flag && this.m_20197_().size() < 2 && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
    }

    public boolean checkBlockCollision(AABB axisalignedbb) {
        BlockPos blockpos = new BlockPos(axisalignedbb.f_82288_ + 0.001, axisalignedbb.f_82289_ + 0.001, axisalignedbb.f_82290_ + 0.001);
        BlockPos blockpos1 = new BlockPos(axisalignedbb.f_82291_ - 0.001, axisalignedbb.f_82292_ - 0.001, axisalignedbb.f_82293_ - 0.001);
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = blockpos.m_123341_(); i <= blockpos1.m_123341_(); ++i) {
            for (int j = blockpos.m_123342_(); j <= blockpos1.m_123342_(); ++j) {
                for (int k = blockpos.m_123343_(); k <= blockpos1.m_123343_(); ++k) {
                    blockpos$mutable.m_122178_(i, j, k);
                    BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
                    if (!blockstate.m_60815_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAdvancedMode() {
        return (Boolean)this.f_19804_.m_135370_(configAdvancedMode);
    }

    public void m_8119_() {
        Entity passenger = this.m_146895_();
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            if (!((Boolean)Config.SHIFT_TO_DISMOUNT.get()).booleanValue()) {
                player.m_20260_(false);
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(configSpeed, (Object)((Integer)Config.MAX_SPEED.get()));
            this.f_19804_.m_135381_(configAdvancedMode, (Object)((Boolean)Config.ADVANCED_MODE.get()));
        }
        if (this.f_19853_.f_46443_) {
            this.updateControl();
        }
        this.summonParticle = (char)(this.summonParticle + '\u0001');
        if (this.summonParticle == '\u0003') {
            this.addParticle(this.f_19853_, this.m_20185_() - 0.5, this.m_20186_() + 0.5, this.m_20189_() - 0.4, 1, 0.0, 1.0, (ParticleOptions)ParticleTypes.f_123784_);
            this.summonParticle = '\u0000';
        }
        this.superTick();
        if (this.m_6109_()) {
            if (this.m_20197_().isEmpty() || !(this.m_20197_().get(0) instanceof Player)) {
                this.m_38339_(false, false);
            }
            this.m_38395_();
            if (this.f_19853_.f_46443_) {
                this.m_38396_();
                this.f_19853_.m_5503_((Packet)new ServerboundPaddleBoatPacket(this.m_38313_(0), this.m_38313_(1)));
            }
            Vec3 vector3d = new Vec3(-this.m_20184_().f_82481_, this.m_20184_().f_82480_, this.m_20184_().f_82479_);
            double percent = (double)((Integer)this.f_19804_.m_135370_(configSpeed)).intValue() / 100.0;
            vector3d = vector3d.m_82542_(percent, 1.0, percent);
            Vec3 v1 = this.m_20182_();
            boolean flag1 = this.checkBlockCollision(this.m_20191_().m_82386_(0.0, -0.1, 0.0));
            boolean flag2 = this.checkBlockCollision(this.m_20191_().m_82383_(vector3d.m_82520_(0.0, -0.1, 0.0)));
            boolean flag3 = this.checkBlockCollision(this.m_20191_().m_82383_(vector3d.m_82520_(0.0, 0.2, 0.0)));
            if (!flag1 && flag2 && !flag3) {
                vector3d = vector3d.m_82520_(0.0, 0.1, 0.0);
            }
            if (this.m_38392_() == Boat.Status.IN_WATER && vector3d.f_82480_ < 0.0) {
                vector3d = new Vec3(vector3d.f_82479_, 0.0, vector3d.f_82481_);
            }
            this.m_6478_(MoverType.SELF, vector3d);
            Vec3 v2 = this.m_20182_().m_82546_(v1);
            if (v2.m_82546_(vector3d).m_82556_() > 1.0E-4) {
                this.m_20334_(v2.f_82481_, v2.f_82480_, -v2.f_82479_);
            }
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        if (!this.m_20197_().isEmpty()) {
            Entity entity = (Entity)this.m_20197_().get(0);
            this.playerSpeed = 0.91636366f;
            this.hasMajoWearable = false;
            entity.m_6168_().forEach(a -> {
                if (a.m_41720_() instanceof MajoWearableItem) {
                    this.hasMajoWearable = true;
                }
            });
            if (!this.hasMajoWearable) {
                this.playerSpeed = Math.max(0.0f, this.playerSpeed - 0.06f);
            }
        } else {
            this.playerSpeed = 0.9f;
        }
        this.serials = (float)((double)this.serials + 0.05);
        if ((double)this.serials > 6.28) {
            this.serials = (float)((double)this.serials - 6.28);
        }
        this.lastfl = this.fl;
        this.fl = (float)Math.sin(2.0f * this.serials);
    }

    public boolean m_5829_() {
        return true;
    }

    protected Vec3 m_7643_(Direction.Axis axis, BlockUtil.FoundRectangle result) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(axis, result));
    }

    public void m_7332_(@NotNull Entity passenger) {
        if (!this.getControlMode()) {
            passenger.f_19859_ += this.f_38266_;
            passenger.f_19857_ += this.f_38266_;
            passenger.m_5616_(passenger.f_19857_);
            passenger.m_5618_(this.f_19857_);
        } else {
            float f = Mth.m_14177_((float)(passenger.f_19857_ - this.f_19857_));
            float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
            passenger.f_19859_ += f1 - f;
            passenger.f_19857_ += f1 - f;
            passenger.m_5616_(passenger.f_19857_);
            passenger.m_5618_(this.f_19857_);
        }
        passenger.m_6034_(this.m_20185_(), this.m_20186_() + this.m_6049_() + passenger.m_6049_() + (double)this.fl * 0.1 + 0.5, this.m_20189_());
    }

    protected void m_20101_() {
        super.m_20101_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.f_19853_.f_46443_ && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91066_.f_92090_.m_90857_() && player.m_20148_() == Minecraft.m_91087_().f_91074_.m_20148_()) {
                Networking.INSTANCE.sendToServer((Object)new RidePack(this.m_19879_(), false));
                this.f_19853_.m_5594_(player, player.m_20183_(), SoundEvents.f_11898_, SoundSource.NEUTRAL, 10.0f, 1.0f);
                this.addParticle(this.f_19853_, this.m_20185_() - 0.5, this.m_20186_() + 0.3, this.m_20189_() - 0.5, 30, 2.0, 1.0, (ParticleOptions)ParticleTypes.f_123762_);
            }
            return false;
        }
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public float getRealFl(float partialTicks) {
        return (1.0f - partialTicks) * this.lastfl + this.fl * partialTicks;
    }

    protected boolean m_7341_(Entity entityIn) {
        return true;
    }

    public void addParticle(Level level, double tx, double ty, double tz, int number, double width, double height, ParticleOptions iParticleData) {
        for (int i = 0; i < number; ++i) {
            double x = Math.random() * width - 0.5 * width;
            double y = Math.random() * height - 0.5 * height;
            double z = Math.random() * width - 0.5 * width;
            level.m_7106_(iParticleData, tx + x + 0.5, ty + y, tz + z + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.f_19853_.f_46443_) {
            if (!Minecraft.m_91087_().f_91066_.f_92090_.m_90857_()) {
                this.hasPassenger = true;
                if (this.m_20197_().isEmpty()) {
                    assert (Minecraft.m_91087_().f_91074_ != null);
                    Networking.INSTANCE.sendToServer((Object)new RidePack(this.m_19879_(), true));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setControls(boolean forward, boolean backward, boolean left, boolean right, boolean up, boolean down) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateControl() {
        if (!this.m_20197_().isEmpty()) {
            assert (Minecraft.m_91087_().f_91074_ != null);
            if (((Entity)this.m_20197_().get(0)).m_20148_() == Minecraft.m_91087_().f_91074_.m_20148_()) {
                this.forward = Minecraft.m_91087_().f_91066_.f_92085_.m_90857_();
                this.backward = Minecraft.m_91087_().f_91066_.f_92087_.m_90857_();
                this.left = Minecraft.m_91087_().f_91066_.f_92086_.m_90857_();
                this.right = Minecraft.m_91087_().f_91066_.f_92088_.m_90857_();
                this.up = KeyBoardInput.up;
                this.down = KeyBoardInput.down;
                if (KeyBoardInput.DOWN_KEY.getKey().m_84873_() == 341 && Minecraft.m_91087_().f_91066_.f_92091_.getKey().m_84873_() == 341) {
                    this.down = Minecraft.m_91087_().f_91066_.f_92091_.m_90857_();
                }
            } else {
                this.down = false;
                this.up = false;
                this.right = false;
                this.left = false;
                this.backward = false;
                this.forward = false;
            }
        } else {
            this.down = false;
            this.up = false;
            this.right = false;
            this.left = false;
            this.backward = false;
            this.forward = false;
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_6123_(Player entityIn) {
        super.m_6123_(entityIn);
    }

    public boolean m_7337_(Entity entity) {
        return super.m_7337_(entity);
    }
}

