/*
 * Decompiled with CFR 0.152.
 */
package com.innky.majobroom.network;

import com.innky.majobroom.entity.MajoBroom;
import com.innky.majobroom.registry.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class RidePack {
    private final int eid;
    private final boolean ride;

    public RidePack(FriendlyByteBuf packetBuffer) {
        this.ride = packetBuffer.readBoolean();
        this.eid = packetBuffer.readInt();
    }

    public RidePack(int eid, boolean ride) {
        this.eid = eid;
        this.ride = ride;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.ride);
        buf.writeInt(this.eid);
    }

    public void handler(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            MajoBroom broomEntity;
            ServerPlayer playerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (playerEntity != null && (broomEntity = (MajoBroom)playerEntity.f_19853_.m_6815_(this.eid)) != null) {
                if (this.ride) {
                    playerEntity.m_20329_((Entity)broomEntity);
                } else {
                    broomEntity.m_142687_(Entity.RemovalReason.KILLED);
                    ItemStack itemStack = new ItemStack((ItemLike)ItemRegistry.broomItem.get());
                    itemStack.m_41784_().m_128379_("controlMode", broomEntity.getControlMode());
                    if (!playerEntity.m_7500_() && !playerEntity.m_150109_().m_36054_(itemStack)) {
                        broomEntity.m_19998_((ItemLike)broomEntity.m_38369_());
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

