/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.nwtg.chatter.ChatterMod;
import net.nwtg.chatter.procedures.ChatterAdminMenuBracketButtonProcedure;
import net.nwtg.chatter.procedures.ChatterAdminMenuGoToPage2Procedure;
import net.nwtg.chatter.procedures.ChatterAdminMenuMessageButtonProcedure;
import net.nwtg.chatter.procedures.ChatterAdminMenuPrefixButtonProcedure;
import net.nwtg.chatter.procedures.ChatterAdminMenuSuffixButtonProcedure;
import net.nwtg.chatter.world.inventory.ChatterAdminMenu1Menu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChatterAdminMenu1ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ChatterAdminMenu1ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ChatterAdminMenu1ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ChatterAdminMenu1ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ChatterAdminMenu1ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ChatterAdminMenu1ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = ChatterAdminMenu1Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ChatterAdminMenuMessageButtonProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 1) {
            ChatterAdminMenuBracketButtonProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 2) {
            ChatterAdminMenuPrefixButtonProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 3) {
            ChatterAdminMenuSuffixButtonProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 4) {
            ChatterAdminMenuGoToPage2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(ChatterAdminMenu1ButtonMessage.class, ChatterAdminMenu1ButtonMessage::buffer, ChatterAdminMenu1ButtonMessage::new, ChatterAdminMenu1ButtonMessage::handler);
    }
}

