/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.nwtg.chatter.ChatterMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChatterModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        ChatterMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.prefixColor = message.data.prefixColor;
                    variables.prefixName = message.data.prefixName;
                    variables.nameColor = message.data.nameColor;
                    variables.bracketColor = message.data.bracketColor;
                    variables.messageColor = message.data.messageColor;
                    variables.nickname = message.data.nickname;
                    variables.startBracketColor = message.data.startBracketColor;
                    variables.startBracketName = message.data.startBracketName;
                    variables.endBracketColor = message.data.endBracketColor;
                    variables.endBracketName = message.data.endBracketName;
                    variables.suffixColor = message.data.suffixColor;
                    variables.suffixName = message.data.suffixName;
                    variables.proximityChatDistance = message.data.proximityChatDistance;
                    variables.world = message.data.world;
                    variables.worldColor = message.data.worldColor;
                    variables.statusName = message.data.statusName;
                    variables.statusColor = message.data.statusColor;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public String prefixColor = "white";
        public String prefixName = "";
        public String nameColor = "white";
        public String bracketColor = "gray";
        public String messageColor = "white";
        public String nickname = "";
        public String startBracketColor = "gray";
        public String startBracketName = "[";
        public String endBracketColor = "gray";
        public String endBracketName = "]";
        public String suffixColor = "white";
        public String suffixName = "";
        public double proximityChatDistance = 3384.0;
        public String world = "";
        public String worldColor = "white";
        public String statusName = "None";
        public String statusColor = "white";

        public void syncPlayerVariables(Entity entity) {
            Entity entity2 = entity;
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                ChatterMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("prefixColor", this.prefixColor);
            nbt.m_128359_("prefixName", this.prefixName);
            nbt.m_128359_("nameColor", this.nameColor);
            nbt.m_128359_("bracketColor", this.bracketColor);
            nbt.m_128359_("messageColor", this.messageColor);
            nbt.m_128359_("nickname", this.nickname);
            nbt.m_128359_("startBracketColor", this.startBracketColor);
            nbt.m_128359_("startBracketName", this.startBracketName);
            nbt.m_128359_("endBracketColor", this.endBracketColor);
            nbt.m_128359_("endBracketName", this.endBracketName);
            nbt.m_128359_("suffixColor", this.suffixColor);
            nbt.m_128359_("suffixName", this.suffixName);
            nbt.m_128347_("proximityChatDistance", this.proximityChatDistance);
            nbt.m_128359_("world", this.world);
            nbt.m_128359_("worldColor", this.worldColor);
            nbt.m_128359_("statusName", this.statusName);
            nbt.m_128359_("statusColor", this.statusColor);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.prefixColor = nbt.m_128461_("prefixColor");
            this.prefixName = nbt.m_128461_("prefixName");
            this.nameColor = nbt.m_128461_("nameColor");
            this.bracketColor = nbt.m_128461_("bracketColor");
            this.messageColor = nbt.m_128461_("messageColor");
            this.nickname = nbt.m_128461_("nickname");
            this.startBracketColor = nbt.m_128461_("startBracketColor");
            this.startBracketName = nbt.m_128461_("startBracketName");
            this.endBracketColor = nbt.m_128461_("endBracketColor");
            this.endBracketName = nbt.m_128461_("endBracketName");
            this.suffixColor = nbt.m_128461_("suffixColor");
            this.suffixName = nbt.m_128461_("suffixName");
            this.proximityChatDistance = nbt.m_128459_("proximityChatDistance");
            this.world = nbt.m_128461_("world");
            this.worldColor = nbt.m_128461_("worldColor");
            this.statusName = nbt.m_128461_("statusName");
            this.statusColor = nbt.m_128461_("statusColor");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("chatter", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "chatter_mapvars";
        public boolean adminMessages = true;
        public boolean adminBrackets = true;
        public boolean adminPrefixes = true;
        public boolean adminSuffixes = true;
        public boolean adminNames = true;
        public boolean adminWorlds = true;
        public boolean adminLocal = true;
        public boolean adminGlobal = true;
        public boolean adminDistance = true;
        public boolean adminStatus = true;
        public double adminMaxmimumDistance = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.adminMessages = nbt.m_128471_("adminMessages");
            this.adminBrackets = nbt.m_128471_("adminBrackets");
            this.adminPrefixes = nbt.m_128471_("adminPrefixes");
            this.adminSuffixes = nbt.m_128471_("adminSuffixes");
            this.adminNames = nbt.m_128471_("adminNames");
            this.adminWorlds = nbt.m_128471_("adminWorlds");
            this.adminLocal = nbt.m_128471_("adminLocal");
            this.adminGlobal = nbt.m_128471_("adminGlobal");
            this.adminDistance = nbt.m_128471_("adminDistance");
            this.adminStatus = nbt.m_128471_("adminStatus");
            this.adminMaxmimumDistance = nbt.m_128459_("adminMaxmimumDistance");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("adminMessages", this.adminMessages);
            nbt.m_128379_("adminBrackets", this.adminBrackets);
            nbt.m_128379_("adminPrefixes", this.adminPrefixes);
            nbt.m_128379_("adminSuffixes", this.adminSuffixes);
            nbt.m_128379_("adminNames", this.adminNames);
            nbt.m_128379_("adminWorlds", this.adminWorlds);
            nbt.m_128379_("adminLocal", this.adminLocal);
            nbt.m_128379_("adminGlobal", this.adminGlobal);
            nbt.m_128379_("adminDistance", this.adminDistance);
            nbt.m_128379_("adminStatus", this.adminStatus);
            nbt.m_128347_("adminMaxmimumDistance", this.adminMaxmimumDistance);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ChatterMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            LevelAccessor levelAccessor = world;
            if (levelAccessor instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)levelAccessor;
                return (MapVariables)serverLevelAcc.m_6018_().m_142572_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "chatter_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            LevelAccessor levelAccessor = world;
            if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).m_5776_()) {
                ChatterMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            LevelAccessor levelAccessor = world;
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)levelAccessor;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.prefixColor = original.prefixColor;
            clone.prefixName = original.prefixName;
            clone.nameColor = original.nameColor;
            clone.bracketColor = original.bracketColor;
            clone.messageColor = original.messageColor;
            clone.nickname = original.nickname;
            clone.startBracketColor = original.startBracketColor;
            clone.startBracketName = original.startBracketName;
            clone.endBracketColor = original.endBracketColor;
            clone.endBracketName = original.endBracketName;
            clone.suffixColor = original.suffixColor;
            clone.suffixName = original.suffixName;
            clone.proximityChatDistance = original.proximityChatDistance;
            clone.world = original.world;
            clone.worldColor = original.worldColor;
            clone.statusName = original.statusName;
            clone.statusColor = original.statusColor;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getPlayer().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getPlayer().f_19853_);
                if (mapdata != null) {
                    ChatterMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ChatterMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getPlayer().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getPlayer().f_19853_)) != null) {
                ChatterMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

