/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.nwtg.chatter.ChatterMod;
import net.nwtg.chatter.procedures.AquaEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.BlackEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.BlueEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkAquaEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkBlueEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkGrayEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkGreenEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkPurpleEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkRedEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.GoldEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.GrayEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.GreenEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.LightPurpleEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.RedEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.WhiteEndBracketButtonProcedure;
import net.nwtg.chatter.procedures.YellowEndBracketButtonProcedure;
import net.nwtg.chatter.world.inventory.EndBracketEditorMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EndBracketEditorButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public EndBracketEditorButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public EndBracketEditorButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(EndBracketEditorButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(EndBracketEditorButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            EndBracketEditorButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = EndBracketEditorMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BlackEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 1) {
            DarkBlueEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 2) {
            DarkGreenEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 3) {
            DarkAquaEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 4) {
            DarkRedEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 5) {
            DarkPurpleEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 6) {
            GoldEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 7) {
            GrayEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 8) {
            DarkGrayEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 9) {
            BlueEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 10) {
            GreenEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 11) {
            AquaEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 12) {
            RedEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 13) {
            LightPurpleEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 14) {
            YellowEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 15) {
            WhiteEndBracketButtonProcedure.execute((Entity)entity, guistate);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(EndBracketEditorButtonMessage.class, EndBracketEditorButtonMessage::buffer, EndBracketEditorButtonMessage::new, EndBracketEditorButtonMessage::handler);
    }
}

