/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.nwtg.chatter.ChatterMod;
import net.nwtg.chatter.procedures.AquaMessageButtonProcedure;
import net.nwtg.chatter.procedures.BlackMessageButtonProcedure;
import net.nwtg.chatter.procedures.BlueMessageButtonProcedure;
import net.nwtg.chatter.procedures.DarkAquaMessageButtonProcedure;
import net.nwtg.chatter.procedures.DarkBlueMessageButtonProcedure;
import net.nwtg.chatter.procedures.DarkGrayMessageButtonProcedure;
import net.nwtg.chatter.procedures.DarkGreenMessageButtonProcedure;
import net.nwtg.chatter.procedures.DarkPurpleMessageButtonProcedure;
import net.nwtg.chatter.procedures.DarkRedMessageButtonProcedure;
import net.nwtg.chatter.procedures.GoldMessageButtonProcedure;
import net.nwtg.chatter.procedures.GrayMessageButtonProcedure;
import net.nwtg.chatter.procedures.GreenMessageButtonProcedure;
import net.nwtg.chatter.procedures.LightPurpleMessageButtonProcedure;
import net.nwtg.chatter.procedures.RedMessageButtonProcedure;
import net.nwtg.chatter.procedures.WhiteMessageButtonProcedure;
import net.nwtg.chatter.procedures.YellowMessageButtonProcedure;
import net.nwtg.chatter.world.inventory.MessageEditorMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MessageEditorButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MessageEditorButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MessageEditorButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MessageEditorButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MessageEditorButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MessageEditorButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = MessageEditorMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BlackMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            DarkBlueMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            DarkGreenMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            DarkAquaMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            DarkRedMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            DarkPurpleMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            GoldMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            GrayMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            DarkGrayMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            BlueMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            GreenMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            AquaMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            RedMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            LightPurpleMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            YellowMessageButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            WhiteMessageButtonProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(MessageEditorButtonMessage.class, MessageEditorButtonMessage::buffer, MessageEditorButtonMessage::new, MessageEditorButtonMessage::handler);
    }
}

