/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.nwtg.chatter.ChatterMod;
import net.nwtg.chatter.procedures.AquaNicknameButtonProcedure;
import net.nwtg.chatter.procedures.BlackNicknameButtonProcedure;
import net.nwtg.chatter.procedures.BlueNicknameButtonProcedure;
import net.nwtg.chatter.procedures.DarkAquaNicknameButtonProcedure;
import net.nwtg.chatter.procedures.DarkBlueNicknameButtonProcedure;
import net.nwtg.chatter.procedures.DarkGrayNicknameButtonProcedure;
import net.nwtg.chatter.procedures.DarkGreenNicknameButtonProcedure;
import net.nwtg.chatter.procedures.DarkPurpleNicknameButtonProcedure;
import net.nwtg.chatter.procedures.DarkRedNicknameButtonProcedure;
import net.nwtg.chatter.procedures.GoldNicknameButtonProcedure;
import net.nwtg.chatter.procedures.GrayNicknameButtonProcedure;
import net.nwtg.chatter.procedures.GreenNicknameButtonProcedure;
import net.nwtg.chatter.procedures.LightPurpleNicknameButtonProcedure;
import net.nwtg.chatter.procedures.RedNicknameButtonProcedure;
import net.nwtg.chatter.procedures.WhiteNicknameButtonProcedure;
import net.nwtg.chatter.procedures.YellowNicknameButtonProcedure;
import net.nwtg.chatter.world.inventory.NameEditorMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NameEditorButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public NameEditorButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public NameEditorButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(NameEditorButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(NameEditorButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            NameEditorButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = NameEditorMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BlackNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 1) {
            DarkBlueNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 2) {
            DarkGreenNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 3) {
            DarkAquaNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 4) {
            DarkRedNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 5) {
            DarkPurpleNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 6) {
            GoldNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 7) {
            GrayNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 8) {
            DarkGrayNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 9) {
            BlueNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 10) {
            GreenNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 11) {
            AquaNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 12) {
            RedNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 13) {
            LightPurpleNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 14) {
            YellowNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 15) {
            WhiteNicknameButtonProcedure.execute((Entity)entity, guistate);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(NameEditorButtonMessage.class, NameEditorButtonMessage::buffer, NameEditorButtonMessage::new, NameEditorButtonMessage::handler);
    }
}

