/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.nwtg.chatter.ChatterMod;
import net.nwtg.chatter.procedures.AquaPrefixButtonProcedure;
import net.nwtg.chatter.procedures.BlackPrefixButtonProcedure;
import net.nwtg.chatter.procedures.BluePrefixButtonProcedure;
import net.nwtg.chatter.procedures.DarkAquaPrefixButtonProcedure;
import net.nwtg.chatter.procedures.DarkBluePrefixButtonProcedure;
import net.nwtg.chatter.procedures.DarkGrayPrefixButtonProcedure;
import net.nwtg.chatter.procedures.DarkGreenPrefixButtonProcedure;
import net.nwtg.chatter.procedures.DarkPurplePrefixButtonProcedure;
import net.nwtg.chatter.procedures.DarkRedPrefixButtonProcedure;
import net.nwtg.chatter.procedures.GoldPrefixButtonProcedure;
import net.nwtg.chatter.procedures.GrayPrefixButtonProcedure;
import net.nwtg.chatter.procedures.GreenPrefixButtonProcedure;
import net.nwtg.chatter.procedures.LightPurplePrefixButtonProcedure;
import net.nwtg.chatter.procedures.RedPrefixButtonProcedure;
import net.nwtg.chatter.procedures.WhitePrefixButtonProcedure;
import net.nwtg.chatter.procedures.YellowPrefixButtonProcedure;
import net.nwtg.chatter.world.inventory.PrefixEditorMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PrefixEditorButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PrefixEditorButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PrefixEditorButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PrefixEditorButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PrefixEditorButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PrefixEditorButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = PrefixEditorMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BlackPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 1) {
            DarkBluePrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 2) {
            DarkGreenPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 3) {
            DarkAquaPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 4) {
            DarkRedPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 5) {
            DarkPurplePrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 6) {
            GoldPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 7) {
            GrayPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 8) {
            DarkGrayPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 9) {
            BluePrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 10) {
            GreenPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 11) {
            AquaPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 12) {
            RedPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 13) {
            LightPurplePrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 14) {
            YellowPrefixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 15) {
            WhitePrefixButtonProcedure.execute((Entity)entity, guistate);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(PrefixEditorButtonMessage.class, PrefixEditorButtonMessage::buffer, PrefixEditorButtonMessage::new, PrefixEditorButtonMessage::handler);
    }
}

