/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.nwtg.chatter.ChatterMod;
import net.nwtg.chatter.procedures.AquaStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.BlackStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.BlueStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkAquaStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkBlueStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkGrayStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkGreenStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkPurpleStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.DarkRedStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.GoldStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.GrayStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.GreenStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.LightPurpleStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.RedStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.WhiteStartBracketButtonProcedure;
import net.nwtg.chatter.procedures.YellowStartBracketButtonProcedure;
import net.nwtg.chatter.world.inventory.StartBracketEditorMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class StartBracketEditorButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public StartBracketEditorButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public StartBracketEditorButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(StartBracketEditorButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(StartBracketEditorButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            StartBracketEditorButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = StartBracketEditorMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BlackStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 1) {
            DarkBlueStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 2) {
            DarkGreenStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 3) {
            DarkAquaStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 4) {
            DarkRedStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 5) {
            DarkPurpleStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 6) {
            GoldStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 7) {
            GrayStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 8) {
            DarkGrayStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 9) {
            BlueStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 10) {
            GreenStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 11) {
            AquaStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 12) {
            RedStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 13) {
            LightPurpleStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 14) {
            YellowStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 15) {
            WhiteStartBracketButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(StartBracketEditorButtonMessage.class, StartBracketEditorButtonMessage::buffer, StartBracketEditorButtonMessage::new, StartBracketEditorButtonMessage::handler);
    }
}

