/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.nwtg.chatter.ChatterMod;
import net.nwtg.chatter.procedures.AquaStatusButtonProcedure;
import net.nwtg.chatter.procedures.BlackStatusButtonProcedure;
import net.nwtg.chatter.procedures.BlueStatusButtonProcedure;
import net.nwtg.chatter.procedures.DarkAquaStatusButtonProcedure;
import net.nwtg.chatter.procedures.DarkBlueStatusButtonProcedure;
import net.nwtg.chatter.procedures.DarkGrayStatusButtonProcedure;
import net.nwtg.chatter.procedures.DarkGreenStatusButtonProcedure;
import net.nwtg.chatter.procedures.DarkPurpleStatusButtonProcedure;
import net.nwtg.chatter.procedures.DarkRedStatusButtonProcedure;
import net.nwtg.chatter.procedures.GoldStatusButtonProcedure;
import net.nwtg.chatter.procedures.GrayStatusButtonProcedure;
import net.nwtg.chatter.procedures.GreenStatusButtonProcedure;
import net.nwtg.chatter.procedures.LightPurpleStatusButtonProcedure;
import net.nwtg.chatter.procedures.RedStatusButtonProcedure;
import net.nwtg.chatter.procedures.WhiteStatusButtonProcedure;
import net.nwtg.chatter.procedures.YellowStatusButtonProcedure;
import net.nwtg.chatter.world.inventory.StatusEditorMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class StatusEditorButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public StatusEditorButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public StatusEditorButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(StatusEditorButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(StatusEditorButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            StatusEditorButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = StatusEditorMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BlackStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 1) {
            DarkBlueStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 2) {
            DarkGreenStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 3) {
            DarkAquaStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 4) {
            DarkRedStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 5) {
            DarkPurpleStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 6) {
            GoldStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 7) {
            GrayStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 8) {
            DarkGrayStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 9) {
            BlueStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 10) {
            GreenStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 11) {
            AquaStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 12) {
            RedStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 13) {
            LightPurpleStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 14) {
            YellowStatusButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 15) {
            WhiteStatusButtonProcedure.execute((Entity)entity, guistate);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(StatusEditorButtonMessage.class, StatusEditorButtonMessage::buffer, StatusEditorButtonMessage::new, StatusEditorButtonMessage::handler);
    }
}

