/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.nwtg.chatter.ChatterMod;
import net.nwtg.chatter.procedures.AquaSuffixButtonProcedure;
import net.nwtg.chatter.procedures.BlackSuffixButtonProcedure;
import net.nwtg.chatter.procedures.BlueSuffixButtonProcedure;
import net.nwtg.chatter.procedures.DarkAquaSuffixButtonProcedure;
import net.nwtg.chatter.procedures.DarkBlueSuffixButtonProcedure;
import net.nwtg.chatter.procedures.DarkGraySuffixButtonProcedure;
import net.nwtg.chatter.procedures.DarkGreenSuffixButtonProcedure;
import net.nwtg.chatter.procedures.DarkPurpleSuffixButtonProcedure;
import net.nwtg.chatter.procedures.DarkRedSuffixButtonProcedure;
import net.nwtg.chatter.procedures.GoldSuffixButtonProcedure;
import net.nwtg.chatter.procedures.GraySuffixButtonProcedure;
import net.nwtg.chatter.procedures.GreenSuffixButtonProcedure;
import net.nwtg.chatter.procedures.LightPurpleSuffixButtonProcedure;
import net.nwtg.chatter.procedures.RedSuffixButtonProcedure;
import net.nwtg.chatter.procedures.WhiteSuffixButtonProcedure;
import net.nwtg.chatter.procedures.YellowSuffixButtonProcedure;
import net.nwtg.chatter.world.inventory.SuffixEditorMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SuffixEditorButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SuffixEditorButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SuffixEditorButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SuffixEditorButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SuffixEditorButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SuffixEditorButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = SuffixEditorMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BlackSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 1) {
            DarkBlueSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 2) {
            DarkGreenSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 3) {
            DarkAquaSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 4) {
            DarkRedSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 5) {
            DarkPurpleSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 6) {
            GoldSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 7) {
            GraySuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 8) {
            DarkGraySuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 9) {
            BlueSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 10) {
            GreenSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 11) {
            AquaSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 12) {
            RedSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 13) {
            LightPurpleSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 14) {
            YellowSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 15) {
            WhiteSuffixButtonProcedure.execute((Entity)entity, guistate);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(SuffixEditorButtonMessage.class, SuffixEditorButtonMessage::buffer, SuffixEditorButtonMessage::new, SuffixEditorButtonMessage::handler);
    }
}

