/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.chatter.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.nwtg.chatter.ChatterMod;
import net.nwtg.chatter.procedures.AquaWorldButtonProcedure;
import net.nwtg.chatter.procedures.BlackWorldButtonProcedure;
import net.nwtg.chatter.procedures.BlueWorldButtonProcedure;
import net.nwtg.chatter.procedures.DarkAquaWorldButtonProcedure;
import net.nwtg.chatter.procedures.DarkBlueWorldButtonProcedure;
import net.nwtg.chatter.procedures.DarkGrayWorldButtonProcedure;
import net.nwtg.chatter.procedures.DarkGreenWorldButtonProcedure;
import net.nwtg.chatter.procedures.DarkPurpleWorldButtonProcedure;
import net.nwtg.chatter.procedures.DarkRedWorldButtonProcedure;
import net.nwtg.chatter.procedures.GoldWorldButtonProcedure;
import net.nwtg.chatter.procedures.GrayWorldButtonProcedure;
import net.nwtg.chatter.procedures.GreenWorldButtonProcedure;
import net.nwtg.chatter.procedures.LightPurpleWorldButtonProcedure;
import net.nwtg.chatter.procedures.RedWorldButtonProcedure;
import net.nwtg.chatter.procedures.WhiteWorldButtonProcedure;
import net.nwtg.chatter.procedures.YellowWorldButtonProcedure;
import net.nwtg.chatter.world.inventory.WorldEditorMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WorldEditorButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public WorldEditorButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public WorldEditorButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(WorldEditorButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(WorldEditorButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            WorldEditorButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = WorldEditorMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BlackWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            DarkBlueWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            DarkGreenWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            DarkAquaWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            DarkRedWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            DarkPurpleWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            GoldWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            GrayWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            DarkGrayWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            BlueWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            GreenWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            AquaWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            RedWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            LightPurpleWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            YellowWorldButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            WhiteWorldButtonProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChatterMod.addNetworkMessage(WorldEditorButtonMessage.class, WorldEditorButtonMessage::buffer, WorldEditorButtonMessage::new, WorldEditorButtonMessage::handler);
    }
}

