/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.ChatLogger;
import net.pcal.fastback.logging.CompositeLogger;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.logging.SaveScreenLogger;
import net.pcal.fastback.utils.GitUtils;
import org.eclipse.jgit.api.Git;

public class LifecycleUtils {
    public static void onInitialize(ModContext ctx) {
        Commands.registerCommands(ctx, ctx.getCommandName());
        ctx.getLogger().info("onInitialize complete");
    }

    public static void onTermination(ModContext ctx) {
        ctx.getLogger().info("onTermination complete");
    }

    public static void onWorldStart(ModContext ctx) {
        ctx.startExecutor();
        Logger logger = ctx.isClient() ? CompositeLogger.of(ctx.getLogger(), new ChatLogger(ctx)) : ctx.getLogger();
        Path worldSaveDir = ctx.getWorldDirectory();
        if (GitUtils.isGitRepo(worldSaveDir)) {
            try (Git git = Git.open((File)worldSaveDir.toFile());){
                WorldConfig.doWorldMaintenance(git, logger);
            }
            catch (IOException e) {
                logger.internalError("Unable to perform maintenance.  Backups will probably not work correctly", e);
            }
        }
        ctx.getLogger().info("onWorldStart complete");
    }

    public static void onWorldStop(ModContext ctx) {
        Logger logger = ctx.isClient() ? CompositeLogger.of(ctx.getLogger(), new SaveScreenLogger(ctx)) : ctx.getLogger();
        Path worldSaveDir = ctx.getWorldDirectory();
        logger.chat(Message.localized("fastback.chat.thread-waiting", new Object[0]));
        ctx.stopExecutor();
        if (GitUtils.isGitRepo(worldSaveDir)) {
            try (Git git = Git.open((File)worldSaveDir.toFile());){
                WorldConfig config = WorldConfig.load(git);
                if (config.isBackupEnabled() && config.shutdownAction() != null) {
                    Logger screenLogger = CompositeLogger.of(ctx.getLogger(), new SaveScreenLogger(ctx));
                    config.shutdownAction().getTask(git, ctx, screenLogger).call();
                }
            }
            catch (Exception e) {
                logger.internalError("Shutdown action failed.", e);
            }
        }
        ctx.getLogger().info("onWorldStop complete");
    }
}

