/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.SchedulableAction;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.retention.RetentionPolicyType;
import net.pcal.fastback.utils.GitUtils;
import org.eclipse.jgit.api.Git;

public class ModContext {
    private final FrameworkServiceProvider spi;
    private ExecutorService executor = null;
    private Path tempRestoresDirectory = null;
    private Future<?> exclusiveFuture = null;

    public static ModContext create(FrameworkServiceProvider spi) {
        return new ModContext(spi);
    }

    private ModContext(FrameworkServiceProvider spi) {
        this.spi = Objects.requireNonNull(spi);
        spi.setAutoSaveListener(new AutosaveListener());
    }

    public boolean execute(ExecutionLock lock, Logger log, Runnable runnable) {
        if (this.executor == null) {
            throw new IllegalStateException("Executor not started");
        }
        switch (lock) {
            case NONE: 
            case WRITE_CONFIG: {
                this.executor.submit(runnable);
                return true;
            }
            case WRITE: {
                if (this.exclusiveFuture != null && !this.exclusiveFuture.isDone()) {
                    log.chatError(Message.localized("fastback.chat.thread-busy", new Object[0]));
                    return false;
                }
                log.debug("executing " + runnable);
                this.exclusiveFuture = this.executor.submit(runnable);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    public void startExecutor() {
        this.executor = new ThreadPoolExecutor(0, 3, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void stopExecutor() {
        ModContext.shutdownExecutor(this.executor);
        this.executor = null;
    }

    public String getCommandName() {
        return "backup";
    }

    public Path getRestoresDir() throws IOException {
        Path restoreDir = this.spi.getSnapshotRestoreDir();
        if (restoreDir != null) {
            return restoreDir;
        }
        if (this.tempRestoresDirectory == null) {
            this.tempRestoresDirectory = Files.createTempDirectory(this.getModId() + "-restore", new FileAttribute[0]);
        }
        return this.tempRestoresDirectory;
    }

    String getModId() {
        return this.spi.getModId();
    }

    public String getModVersion() {
        return this.spi.getModVersion();
    }

    public String getMinecraftVersion() {
        return this.spi.getMinecraftVersion();
    }

    public Path getMinecraftConfigDir() {
        return this.spi.getConfigDir();
    }

    public void setWorldSaveEnabled(boolean enabled) {
        this.spi.setWorldSaveEnabled(enabled);
    }

    public boolean isClient() {
        return this.spi.isClient();
    }

    public boolean isServerStopping() {
        return this.spi.isServerStopping();
    }

    public void setSavingScreenText(Message message) {
        this.spi.setClientSavingScreenText(message);
    }

    public void sendClientChatMessage(Message message) {
        this.spi.sendClientChatMessage(message);
    }

    public void sendFeedback(Message message, class_2168 scs) {
        this.spi.sendFeedback(message, scs);
    }

    public void sendError(Message message, class_2168 scs) {
        this.spi.sendError(message, scs);
    }

    public void renderBackupIndicator(Message message) {
        this.spi.setHudText(message);
    }

    public Path getWorldDirectory() {
        return this.spi.getWorldDirectory();
    }

    public String getWorldName() {
        return this.spi.getWorldName();
    }

    public Logger getLogger() {
        return this.spi.getLogger();
    }

    public boolean isExperimentalCommandsEnabled() {
        return false;
    }

    public boolean isStartupNotificationEnabled() {
        return true;
    }

    public boolean isFileRemoteBare() {
        return true;
    }

    public boolean isReflogDeletionEnabled() {
        return true;
    }

    public boolean isBranchCleanupEnabled() {
        return true;
    }

    public int getDefaultPermLevel() {
        return this.spi.isClient() ? 0 : 4;
    }

    public List<RetentionPolicyType> getRetentionPolicyTypes() {
        return RetentionPolicyType.getAvailable();
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public void saveWorld() {
        this.spi.saveWorld();
    }

    private static void shutdownExecutor(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(5L, TimeUnit.MINUTES)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(5L, TimeUnit.MINUTES)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static interface FrameworkServiceProvider {
        public Logger getLogger();

        public String getModId();

        public String getModVersion();

        public Path getConfigDir();

        public String getMinecraftVersion();

        public Path getWorldDirectory();

        public String getWorldName();

        public void setClientSavingScreenText(Message var1);

        public void sendClientChatMessage(Message var1);

        public Path getSnapshotRestoreDir();

        public boolean isClient();

        public boolean isWorldSaveEnabled();

        public void setWorldSaveEnabled(boolean var1);

        public void saveWorld();

        public boolean isServerStopping();

        public void setHudText(Message var1);

        public void sendFeedback(Message var1, class_2168 var2);

        public void sendError(Message var1, class_2168 var2);

        public void setAutoSaveListener(Runnable var1);
    }

    class AutosaveListener
    implements Runnable {
        private long lastBackupTime = System.currentTimeMillis();

        AutosaveListener() {
        }

        @Override
        public void run() {
            ModContext.this.execute(ExecutionLock.WRITE, ModContext.this.getLogger(), () -> {
                Path worldSaveDir = ModContext.this.getWorldDirectory();
                if (!GitUtils.isGitRepo(worldSaveDir)) {
                    return;
                }
                try (Git git = Git.open((File)worldSaveDir.toFile());){
                    WorldConfig config = WorldConfig.load(git);
                    if (!config.isBackupEnabled()) {
                        return;
                    }
                    SchedulableAction autobackAction = config.autobackAction();
                    if (autobackAction == null || autobackAction == SchedulableAction.NONE) {
                        return;
                    }
                    Duration timeRemaining = config.autobackWait().minus(Duration.ofMillis(System.currentTimeMillis() - this.lastBackupTime));
                    if (!timeRemaining.isZero() && !timeRemaining.isNegative()) {
                        ModContext.this.getLogger().debug("Skipping auto-backup until at least " + timeRemaining.toSeconds() / 60L + " more minutes have elapsed.");
                        return;
                    }
                    ModContext.this.getLogger().info("Starting auto-backup");
                    autobackAction.getTask(git, ModContext.this, ModContext.this.getLogger()).call();
                    this.lastBackupTime = System.currentTimeMillis();
                }
                catch (Exception e) {
                    ModContext.this.getLogger().internalError("auto-backup failed.", e);
                }
            });
        }
    }

    public static enum ExecutionLock {
        NONE,
        WRITE_CONFIG,
        WRITE;

    }
}

