/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import net.pcal.fastback.commands.SchedulableAction;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.utils.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;

public record WorldConfig(String worldUuid, boolean isBackupEnabled, SchedulableAction autobackAction, Duration autobackWait, SchedulableAction shutdownAction, String localRetentionPolicy, String remoteRetentionPolicy, String getRemotePushUrl) {
    public static final Path WORLD_UUID_PATH = Path.of("fastback/world.uuid", new String[0]);
    private static final String REMOTE_NAME = "origin";
    private static final String CONFIG_SECTION = "fastback";
    private static final String CONFIG_BACKUP_ENABLED = "backup-enabled";
    private static final String CONFIG_LOCAL_RETENTION_POLICY = "retention-policy";
    private static final String CONFIG_REMOTE_RETENTION_POLICY = "remote-retention-policy";
    private static final String CONFIG_AUTOBACK_ACTION = "autoback-action";
    private static final String CONFIG_AUTOBACK_WAIT = "autoback-wait";
    private static final String CONFIG_SHUTDOWN_ACTION = "shutdown-action";
    private static final String CONFIG_UPDATE_GITIGNORE_ENABLED = "update-gitignore-enabled";
    private static final String CONFIG_UPDATE_GITATTRIBUTES_ENABLED = "update-gitattributes-enabled";
    private static final Iterable<WorldResource> WORLD_RESOURCES = List.of(new WorldResource("world/dot-gitignore", Path.of(".gitignore", new String[0]), "update-gitignore-enabled"), new WorldResource("world/dot-gitattributes", Path.of(".gitattributes", new String[0]), "update-gitattributes-enabled"));

    public static WorldConfig load(Git git) throws IOException {
        StoredConfig gitConfig = git.getRepository().getConfig();
        SchedulableAction autobackAction = WorldConfig.retrieveAction((Config)gitConfig, CONFIG_AUTOBACK_ACTION);
        int autobackWait = gitConfig.getInt(CONFIG_SECTION, CONFIG_AUTOBACK_WAIT, 0);
        SchedulableAction shutdownAction = WorldConfig.retrieveAction((Config)gitConfig, CONFIG_SHUTDOWN_ACTION);
        if (shutdownAction == null && gitConfig.getBoolean(CONFIG_SECTION, null, "shutdown-backup-enabled", false)) {
            shutdownAction = SchedulableAction.DEFAULT_SHUTDOWN_ACTION;
        }
        return new WorldConfig(WorldConfig.getWorldUuid(git), gitConfig.getBoolean(CONFIG_SECTION, null, CONFIG_BACKUP_ENABLED, false), autobackAction, Duration.ofMinutes(autobackWait), shutdownAction, gitConfig.getString(CONFIG_SECTION, null, CONFIG_LOCAL_RETENTION_POLICY), gitConfig.getString(CONFIG_SECTION, null, CONFIG_REMOTE_RETENTION_POLICY), gitConfig.getString("remote", REMOTE_NAME, "url"));
    }

    private static SchedulableAction retrieveAction(Config gitConfig, String configKey) {
        String shutdownActionRaw = gitConfig.getString(CONFIG_SECTION, null, configKey);
        return shutdownActionRaw != null ? SchedulableAction.getForConfigKey(shutdownActionRaw) : null;
    }

    public String getRemoteName() {
        return REMOTE_NAME;
    }

    public boolean isUuidCheckEnabled() {
        return true;
    }

    public boolean isTempBranchCleanupEnabled() {
        return true;
    }

    public boolean isTrackingBranchCleanupEnabled() {
        return true;
    }

    public boolean isRemoteTempBranchCleanupEnabled() {
        return true;
    }

    public boolean isSmartPushEnabled() {
        return true;
    }

    public boolean isPostRestoreCleanupEnabled() {
        return true;
    }

    public static void setRemoteUrl(Config gitConfig, String url) {
        gitConfig.setString("remote", REMOTE_NAME, "url", url);
    }

    public static void setBackupEnabled(Config gitConfig, boolean value) {
        gitConfig.setBoolean(CONFIG_SECTION, null, CONFIG_BACKUP_ENABLED, value);
    }

    public static void setLocalRetentionPolicy(Config gitConfig, String value) {
        gitConfig.setString(CONFIG_SECTION, null, CONFIG_LOCAL_RETENTION_POLICY, value);
    }

    public static void setRemoteRetentionPolicy(Config gitConfig, String value) {
        gitConfig.setString(CONFIG_SECTION, null, CONFIG_REMOTE_RETENTION_POLICY, value);
    }

    public static void setAutobackAction(Config gitConfig, SchedulableAction action) {
        gitConfig.setString(CONFIG_SECTION, null, CONFIG_AUTOBACK_ACTION, action.getConfigKey());
    }

    public static void setAutobackWait(Config gitConfig, int waitTimeMinutes) {
        gitConfig.setInt(CONFIG_SECTION, null, CONFIG_AUTOBACK_WAIT, waitTimeMinutes);
    }

    public static void setShutdownAction(Config gitConfig, SchedulableAction action) {
        gitConfig.setString(CONFIG_SECTION, null, CONFIG_SHUTDOWN_ACTION, action.getConfigKey());
    }

    public static String getWorldUuid(Git git) throws IOException {
        return Files.readString(git.getRepository().getWorkTree().toPath().toAbsolutePath().resolve(WORLD_UUID_PATH)).trim();
    }

    private static void ensureWorldHasUuid(Path worldSaveDir, Logger logger) throws IOException {
        Path worldUuidpath = worldSaveDir.resolve(WORLD_UUID_PATH);
        if (!worldUuidpath.toFile().exists()) {
            FileUtils.mkdirs(worldUuidpath.getParent());
            String newUuid = UUID.randomUUID().toString();
            try (FileWriter fw = new FileWriter(worldUuidpath.toFile());){
                fw.append(newUuid);
                fw.append('\n');
            }
            logger.info("Generated new world.uuid " + newUuid);
        }
    }

    public static void doWorldMaintenance(Git git, Logger logger) throws IOException {
        logger.info("Doing world maintenance");
        Path worldSaveDir = git.getRepository().getWorkTree().toPath();
        WorldConfig.ensureWorldHasUuid(worldSaveDir, logger);
        StoredConfig config = git.getRepository().getConfig();
        for (WorldResource resource : WORLD_RESOURCES) {
            if (config.getBoolean(CONFIG_SECTION, resource.permission, true)) {
                logger.debug("Updating " + resource.targetPath);
                Path targetPath = worldSaveDir.resolve(resource.targetPath);
                FileUtils.writeResourceToFile(resource.resourcePath, targetPath);
                continue;
            }
            logger.info("Updates disabled for " + resource.targetPath);
        }
    }

    private record WorldResource(String resourcePath, Path targetPath, String permission) {
    }
}

