/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.CreateFileRemoteCommand;
import net.pcal.fastback.commands.DeleteCommand;
import net.pcal.fastback.commands.DisableCommand;
import net.pcal.fastback.commands.EnableCommand;
import net.pcal.fastback.commands.FullCommand;
import net.pcal.fastback.commands.GcCommand;
import net.pcal.fastback.commands.HelpCommand;
import net.pcal.fastback.commands.InfoCommand;
import net.pcal.fastback.commands.ListCommand;
import net.pcal.fastback.commands.LocalCommand;
import net.pcal.fastback.commands.PruneCommand;
import net.pcal.fastback.commands.RemoteDeleteCommand;
import net.pcal.fastback.commands.RemoteListCommand;
import net.pcal.fastback.commands.RemotePruneCommand;
import net.pcal.fastback.commands.RemoteRestoreCommand;
import net.pcal.fastback.commands.RestoreCommand;
import net.pcal.fastback.commands.SaveCommand;
import net.pcal.fastback.commands.SetAutobackActionCommand;
import net.pcal.fastback.commands.SetAutobackWaitCommand;
import net.pcal.fastback.commands.SetRemoteCommand;
import net.pcal.fastback.commands.SetRemoteRetentionCommand;
import net.pcal.fastback.commands.SetRetentionCommand;
import net.pcal.fastback.commands.SetShutdownActionCommand;
import net.pcal.fastback.logging.CommandSourceLogger;
import net.pcal.fastback.logging.CompositeLogger;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.logging.SaveScreenLogger;
import net.pcal.fastback.utils.GitUtils;
import org.eclipse.jgit.api.Git;

public class Commands {
    static String BACKUP_COMMAND_PERM = "fastback.command";
    static int FAILURE = 0;
    static int SUCCESS = 1;

    public static void registerCommands(ModContext ctx, String cmd) {
        LiteralArgumentBuilder argb = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)cmd).requires(Permissions.require((String)BACKUP_COMMAND_PERM, (int)ctx.getDefaultPermLevel()));
        EnableCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        DisableCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        LocalCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        FullCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        InfoCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        RestoreCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        CreateFileRemoteCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        SetRemoteCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        SetAutobackActionCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        SetAutobackWaitCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        SetShutdownActionCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        SetRetentionCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        SetRemoteRetentionCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        PruneCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        DeleteCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        GcCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        ListCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        RemoteListCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        RemoteDeleteCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        RemotePruneCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        RemoteRestoreCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        HelpCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        if (ctx.isExperimentalCommandsEnabled()) {
            SaveCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)argb, ctx);
        }
        CommandRegistrationCallback.EVENT.register((dispatcher, regAccess, env) -> dispatcher.register(argb));
    }

    public static Logger commandLogger(ModContext ctx, class_2168 scs) {
        return CompositeLogger.of(ctx.getLogger(), new CommandSourceLogger(ctx, scs), new SaveScreenLogger(ctx));
    }

    public static String subcommandPermName(String subcommandName) {
        return "fastback.command." + subcommandName;
    }

    public static Predicate<class_2168> subcommandPermission(ModContext ctx, String subcommandName) {
        return Permissions.require((String)Commands.subcommandPermName(subcommandName), (int)ctx.getDefaultPermLevel());
    }

    static void gitOp(ModContext ctx, ModContext.ExecutionLock lock, Logger log, GitOp op) {
        ctx.execute(lock, log, () -> {
            Path worldSaveDir = ctx.getWorldDirectory();
            if (!GitUtils.isGitRepo(worldSaveDir)) {
                log.chatError(Message.localized("fastback.chat.not-enabled", new Object[0]));
                return;
            }
            try (Git git = Git.open((File)worldSaveDir.toFile());){
                WorldConfig worldConfig = WorldConfig.load(git);
                if (!worldConfig.isBackupEnabled()) {
                    log.chatError(Message.localized("fastback.chat.not-enabled", new Object[0]));
                } else {
                    op.execute(git);
                }
            }
            catch (Exception e) {
                log.internalError("Command execution failed.", e);
            }
            finally {
                log.hud(null);
            }
        });
    }

    static interface GitOp {
        public void execute(Git var1) throws Exception;
    }
}

