/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.utils.FileUtils;
import net.pcal.fastback.utils.GitUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;

enum CreateFileRemoteCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "create-file-remote";
    private static final String ARGUMENT = "file-path";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(ctx, COMMAND_NAME))).then(class_2170.method_9244((String)ARGUMENT, (ArgumentType)StringArgumentType.greedyString()).executes(cc -> CreateFileRemoteCommand.setFileRemote(ctx, (CommandContext<class_2168>)cc))));
    }

    private static int setFileRemote(ModContext ctx, CommandContext<class_2168> cc) {
        Logger log = Commands.commandLogger(ctx, (class_2168)cc.getSource());
        Commands.gitOp(ctx, ModContext.ExecutionLock.NONE, log, git -> {
            String targetPath = (String)cc.getArgument(ARGUMENT, String.class);
            Path fupHome = Path.of(targetPath, new String[0]);
            if (fupHome.toFile().exists()) {
                log.chatError(Message.localized("fastback.chat.create-file-remote-dir-exists", fupHome.toString()));
                return;
            }
            FileUtils.mkdirs(fupHome);
            try (Git targetGit = Git.init().setBare(ctx.isFileRemoteBare()).setDirectory(fupHome.toFile()).call();){
                StoredConfig targetGitc = targetGit.getRepository().getConfig();
                targetGitc.setInt("pack", null, "window", 0);
                targetGitc.setInt("core", null, "bigFileThreshold", 1);
                targetGitc.save();
            }
            String targetUrl = GitUtils.getFileUri(fupHome);
            StoredConfig gitc = git.getRepository().getConfig();
            WorldConfig.setRemoteUrl((Config)gitc, targetUrl);
            gitc.save();
            log.chat(Message.localized("fastback.chat.create-file-remote-created", targetPath, targetUrl));
        });
        return Commands.SUCCESS;
    }
}

