/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.SnapshotNameSuggestions;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.utils.SnapshotId;

enum DeleteCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "delete";
    private static final String ARGUMENT = "snapshot";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(ctx, COMMAND_NAME))).then(class_2170.method_9244((String)ARGUMENT, (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)SnapshotNameSuggestions.local(ctx)).executes(cc -> DeleteCommand.delete(ctx, (CommandContext<class_2168>)cc))));
    }

    private static int delete(ModContext ctx, CommandContext<class_2168> cc) {
        Logger log = Commands.commandLogger(ctx, (class_2168)cc.getSource());
        Commands.gitOp(ctx, ModContext.ExecutionLock.WRITE, log, git -> {
            String snapshotName = (String)cc.getLastChild().getArgument(ARGUMENT, String.class);
            WorldConfig wc = WorldConfig.load(git);
            SnapshotId sid = SnapshotId.fromUuidAndName(wc.worldUuid(), snapshotName);
            String branchName = sid.getBranchName();
            git.branchDelete().setForce(true).setBranchNames(new String[]{branchName}).call();
            log.chat(Message.localized("fastback.chat.delete-done", snapshotName));
        });
        return Commands.SUCCESS;
    }
}

