/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.SchedulableAction;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;

enum EnableCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "enable";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(ctx, COMMAND_NAME))).executes(cc -> EnableCommand.enable(ctx, (CommandContext<class_2168>)cc)));
    }

    private static int enable(ModContext ctx, CommandContext<class_2168> cc) {
        Logger log = Commands.commandLogger(ctx, (class_2168)cc.getSource());
        ctx.execute(ModContext.ExecutionLock.NONE, log, () -> {
            Path worldSaveDir = ctx.getWorldDirectory();
            try (Git git = Git.init().setDirectory(worldSaveDir.toFile()).call();){
                WorldConfig.doWorldMaintenance(git, log);
                StoredConfig config = git.getRepository().getConfig();
                WorldConfig worldConfig = WorldConfig.load(git);
                WorldConfig.setBackupEnabled((Config)config, true);
                if (worldConfig.shutdownAction() == null) {
                    WorldConfig.setShutdownAction((Config)config, SchedulableAction.DEFAULT_SHUTDOWN_ACTION);
                }
                config.save();
                log.chat(Message.localized("fastback.chat.enable-done", new Object[0]));
            }
            catch (IOException | GitAPIException e) {
                log.internalError("Error enabling backups", e);
            }
        });
        return Commands.SUCCESS;
    }
}

