/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;

enum HelpCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "help";
    private static final String ARGUMENT = "subcommand";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        argb.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(ctx, COMMAND_NAME))).executes(cc -> this.help(ctx, (CommandContext<class_2168>)cc))).then(class_2170.method_9244((String)ARGUMENT, (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new HelpTopicSuggestions(ctx)).executes(cc -> this.helpSubcommand(ctx, (CommandContext<class_2168>)cc))));
    }

    private int help(ModContext ctx, CommandContext<class_2168> cc) {
        Logger log = Commands.commandLogger(ctx, (class_2168)cc.getSource());
        StringWriter subcommands = null;
        for (String available : HelpCommand.getSubcommandNames(cc)) {
            if (subcommands == null) {
                subcommands = new StringWriter();
            } else {
                subcommands.append(", ");
            }
            subcommands.append(available);
        }
        log.chat(Message.localized("fastback.help.subcommands", String.valueOf(subcommands)));
        return Commands.SUCCESS;
    }

    private int helpSubcommand(ModContext ctx, CommandContext<class_2168> cc) {
        Logger log = Commands.commandLogger(ctx, (class_2168)cc.getSource());
        Collection subcommands = ((ParsedCommandNode)cc.getNodes().get(0)).getNode().getChildren();
        String subcommand = (String)cc.getLastChild().getArgument(ARGUMENT, String.class);
        for (String available : HelpCommand.getSubcommandNames(cc)) {
            if (!subcommand.equals(available)) continue;
            String prefix = "/backup " + subcommand + ": ";
            log.chat(Message.localized("fastback.help.command." + subcommand, prefix));
            return Commands.SUCCESS;
        }
        log.chatError(Message.localized("fastback.chat.invalid-input", subcommand));
        return Commands.FAILURE;
    }

    private static List<String> getSubcommandNames(CommandContext<class_2168> cc) {
        ArrayList<String> out = new ArrayList<String>();
        ((ParsedCommandNode)cc.getNodes().get(0)).getNode().getChildren().forEach(node -> out.add(node.getName()));
        return out;
    }

    private static class HelpTopicSuggestions
    implements SuggestionProvider<class_2168> {
        private final ModContext ctx;

        HelpTopicSuggestions(ModContext ctx) {
            this.ctx = Objects.requireNonNull(ctx);
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> cc, SuggestionsBuilder builder) {
            CompletableFuture<Suggestions> completableFuture = new CompletableFuture<Suggestions>();
            HelpCommand.getSubcommandNames(cc).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            try {
                completableFuture.complete((Suggestions)builder.buildFuture().get());
            }
            catch (InterruptedException | ExecutionException e) {
                this.ctx.getLogger().internalError("looking up help topics", e);
                return null;
            }
            return completableFuture;
        }
    }
}

