/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.SchedulableAction;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyCodec;
import net.pcal.fastback.retention.RetentionPolicyType;
import org.apache.commons.io.FileUtils;

enum InfoCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "info";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(ctx, COMMAND_NAME))).executes(cc -> InfoCommand.info(ctx, (class_2168)cc.getSource())));
    }

    private static int info(ModContext ctx, class_2168 scs) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(scs);
        Logger log = Commands.commandLogger(ctx, scs);
        Commands.gitOp(ctx, ModContext.ExecutionLock.NONE, log, git -> {
            WorldConfig wc = WorldConfig.load(git);
            log.chat(Message.localized("fastback.chat.info-fastback-version", ctx.getModVersion()));
            log.chat(Message.localized("fastback.chat.info-uuid", wc.worldUuid()));
            if (wc.isBackupEnabled()) {
                log.chat(Message.localized("fastback.chat.info-local-enabled", new Object[0]));
            } else {
                log.chat(Message.localized("fastback.chat.info-local-disabled", new Object[0]));
            }
            log.chat(Message.localized("fastback.chat.info-remote-url", wc.getRemotePushUrl()));
            log.chat(Message.localized("fastback.chat.info-shutdown-action", InfoCommand.getActionDisplay(wc.shutdownAction())));
            log.chat(Message.localized("fastback.chat.info-autoback-action", InfoCommand.getActionDisplay(wc.autobackAction())));
            log.chat(Message.localized("fastback.chat.info-autoback-wait", wc.autobackWait() == null ? "" : Long.valueOf(wc.autobackWait().getSeconds() / 60L)));
            long backupSize = FileUtils.sizeOfDirectory((File)git.getRepository().getDirectory());
            long worldSize = FileUtils.sizeOfDirectory((File)git.getRepository().getWorkTree()) - backupSize;
            log.chat(Message.localized("fastback.chat.info-world-size", FileUtils.byteCountToDisplaySize((long)worldSize)));
            log.chat(Message.localized("fastback.chat.info-backup-size", FileUtils.byteCountToDisplaySize((long)backupSize)));
            InfoCommand.showRetentionPolicy(ctx, log, wc.localRetentionPolicy(), "fastback.chat.retention-policy-set", "fastback.chat.retention-policy-none");
            InfoCommand.showRetentionPolicy(ctx, log, wc.remoteRetentionPolicy(), "fastback.chat.remote-retention-policy-set", "fastback.chat.remote-retention-policy-none");
        });
        return Commands.SUCCESS;
    }

    private static String getActionDisplay(SchedulableAction action) {
        return action == null ? SchedulableAction.NONE.getArgumentName() : action.getArgumentName();
    }

    private static void showRetentionPolicy(ModContext ctx, Logger log, String encodedPolicy, String setKey, String noneKey) {
        if (encodedPolicy == null) {
            log.chat(Message.localized(noneKey, new Object[0]));
        } else {
            RetentionPolicy policy = RetentionPolicyCodec.INSTANCE.decodePolicy(ctx, RetentionPolicyType.getAvailable(), encodedPolicy);
            if (policy == null) {
                log.chat(Message.localized(noneKey, new Object[0]));
            } else {
                log.chat(Message.localized(setKey, new Object[0]));
                log.chat(policy.getDescription());
            }
        }
    }
}

