/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.google.common.collect.ListMultimap;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.tasks.ListSnapshotsTask;
import net.pcal.fastback.utils.SnapshotId;

enum RemoteListCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "remote-list";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(ctx, COMMAND_NAME))).executes(cc -> RemoteListCommand.remoteList(ctx, (CommandContext<class_2168>)cc)));
    }

    private static int remoteList(ModContext ctx, CommandContext<class_2168> cc) {
        Logger log = Commands.commandLogger(ctx, (class_2168)cc.getSource());
        Commands.gitOp(ctx, ModContext.ExecutionLock.NONE, log, git -> {
            WorldConfig wc = WorldConfig.load(git);
            ListMultimap<String, SnapshotId> snapshotsPerWorld = ListSnapshotsTask.listRemoteSnapshots(git, wc, log);
            ArrayList snapshots = new ArrayList(snapshotsPerWorld.get((Object)wc.worldUuid()));
            Collections.sort(snapshots);
            snapshots.forEach(sid -> log.chat(Message.raw(sid.getName())));
            log.chat(Message.localized("fastback.chat.remote-list-done", snapshots.size(), wc.getRemotePushUrl()));
            if (snapshotsPerWorld.keySet().size() > 1) {
                log.chat(Message.localized("fastback.chat.remote-list-others", snapshotsPerWorld.size() - 1, snapshotsPerWorld.size() - snapshots.size()));
            }
        });
        return Commands.SUCCESS;
    }
}

