/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.nio.file.Path;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.SnapshotNameSuggestions;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.tasks.RestoreSnapshotTask;
import net.pcal.fastback.utils.SnapshotId;

enum RemoteRestoreCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "remote-restore";
    private static final String ARGUMENT = "snapshot";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(ctx, COMMAND_NAME))).then(class_2170.method_9244((String)ARGUMENT, (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)SnapshotNameSuggestions.remote(ctx)).executes(cc -> RemoteRestoreCommand.remoteRestore(ctx, (CommandContext<class_2168>)cc))));
    }

    private static int remoteRestore(ModContext ctx, CommandContext<class_2168> cc) {
        Logger log = Commands.commandLogger(ctx, (class_2168)cc.getSource());
        Commands.gitOp(ctx, ModContext.ExecutionLock.NONE, log, git -> {
            WorldConfig wc = WorldConfig.load(git);
            String snapshotName = (String)cc.getLastChild().getArgument(ARGUMENT, String.class);
            SnapshotId sid = SnapshotId.fromUuidAndName(wc.worldUuid(), snapshotName);
            String uri = wc.getRemotePushUrl();
            Path restoreDir = new RestoreSnapshotTask(uri, ctx.getRestoresDir(), ctx.getWorldName(), sid, log).call();
            log.chat(Message.localized("fastback.chat.restore-done", restoreDir));
        });
        return Commands.SUCCESS;
    }
}

