/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import java.util.Objects;
import java.util.concurrent.Callable;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.tasks.CommitAndPushTask;
import net.pcal.fastback.tasks.CommitTask;
import net.pcal.fastback.tasks.GcTask;
import net.pcal.fastback.tasks.LocalPruneTask;
import net.pcal.fastback.utils.SnapshotId;
import org.eclipse.jgit.api.Git;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SchedulableAction {
    NONE("none"){

        public Callable<Void> getTask(Git git, ModContext ctx, Logger log) {
            return () -> null;
        }
    }
    ,
    LOCAL("local"){

        public Callable<SnapshotId> getTask(Git git, ModContext ctx, Logger log) {
            return new CommitTask(git, ctx, log);
        }
    }
    ,
    FULL("full"){

        public Callable<Void> getTask(Git git, ModContext ctx, Logger log) {
            return new CommitAndPushTask(git, ctx, log);
        }
    }
    ,
    FULL_GC("full-gc"){

        public Callable<Void> getTask(Git git, ModContext ctx, Logger log) {
            return () -> {
                new CommitAndPushTask(git, ctx, log).call();
                Object pruned = new LocalPruneTask(git, ctx, log).call();
                if (pruned.size() > 0) {
                    new GcTask(git, ctx, log).call();
                }
                return null;
            };
        }
    };

    public static final SchedulableAction DEFAULT_SHUTDOWN_ACTION;
    private final String configKey;

    public static SchedulableAction getForConfigKey(String configKey) {
        for (SchedulableAction action : SchedulableAction.values()) {
            if (!action.configKey.equals(configKey)) continue;
            return action;
        }
        return null;
    }

    private SchedulableAction(String configKey) {
        this.configKey = Objects.requireNonNull(configKey);
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getArgumentName() {
        return this.configKey;
    }

    public abstract Callable<?> getTask(Git var1, ModContext var2, Logger var3);

    static {
        DEFAULT_SHUTDOWN_ACTION = FULL;
    }
}

