/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;

enum SetRemoteCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "set-remote";
    private static final String URL_ARGUMENT = "remote-url";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(ctx, COMMAND_NAME))).then(class_2170.method_9244((String)URL_ARGUMENT, (ArgumentType)StringArgumentType.greedyString()).executes(cc -> SetRemoteCommand.setRemoteUrl(ctx, (CommandContext<class_2168>)cc))));
    }

    private static int setRemoteUrl(ModContext ctx, CommandContext<class_2168> cc) {
        Logger log = Commands.commandLogger(ctx, (class_2168)cc.getSource());
        Commands.gitOp(ctx, ModContext.ExecutionLock.WRITE_CONFIG, log, git -> {
            String newUrl = (String)cc.getArgument(URL_ARGUMENT, String.class);
            StoredConfig gitc = git.getRepository().getConfig();
            WorldConfig.setRemoteUrl((Config)gitc, newUrl);
            gitc.save();
            log.chat(Message.localized("fastback.chat.remote-enabled", newUrl));
        });
        return Commands.SUCCESS;
    }
}

