/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyCodec;
import net.pcal.fastback.retention.RetentionPolicyType;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;

enum SetRetentionCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "set-retention";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        SetRetentionCommand.registerSetRetentionCommand(argb, ctx, COMMAND_NAME, (cc, rt) -> SetRetentionCommand.setLocalPolicy(ctx, (CommandContext<class_2168>)cc, rt));
    }

    private static int setLocalPolicy(ModContext ctx, CommandContext<class_2168> cc, RetentionPolicyType rpt) {
        return SetRetentionCommand.setRetentionPolicy(ctx, cc, rpt, WorldConfig::setLocalRetentionPolicy);
    }

    static void registerSetRetentionCommand(LiteralArgumentBuilder<class_2168> argb, ModContext ctx, String commandName, BiFunction<CommandContext<class_2168>, RetentionPolicyType, Integer> setPolicyFn) {
        LiteralArgumentBuilder retainCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(Commands.subcommandPermission(ctx, commandName));
        for (RetentionPolicyType rpt : ctx.getRetentionPolicyTypes()) {
            LiteralArgumentBuilder policyCommand = class_2170.method_9247((String)rpt.getCommandName());
            policyCommand.executes(cc -> (Integer)setPolicyFn.apply(cc, rpt));
            if (rpt.getParameters() != null) {
                for (RetentionPolicyType.Parameter param : rpt.getParameters()) {
                    policyCommand.then(class_2170.method_9244((String)param.name(), param.type()).executes(cc -> (Integer)setPolicyFn.apply(cc, rpt)));
                }
            }
            retainCommand.then((ArgumentBuilder)policyCommand);
        }
        argb.then((ArgumentBuilder)retainCommand);
    }

    public static int setRetentionPolicy(ModContext ctx, CommandContext<class_2168> cc, RetentionPolicyType rpt, BiConsumer<Config, String> setEncodedPolicyFn) {
        Logger logger = Commands.commandLogger(ctx, (class_2168)cc.getSource());
        try {
            Path worldSaveDir = ctx.getWorldDirectory();
            HashMap<String, String> config = new HashMap<String, String>();
            for (RetentionPolicyType.Parameter p : rpt.getParameters()) {
                Object val = cc.getArgument(p.name(), Object.class);
                config.put(p.name(), String.valueOf(val));
            }
            String encodedPolicy = RetentionPolicyCodec.INSTANCE.encodePolicy(ctx, rpt, config);
            RetentionPolicy rp = RetentionPolicyCodec.INSTANCE.decodePolicy(ctx, RetentionPolicyType.getAvailable(), encodedPolicy);
            if (rp == null) {
                logger.internalError("Failed to decode policy " + encodedPolicy, new Exception());
                return Commands.FAILURE;
            }
            try (Git git = Git.open((File)worldSaveDir.toFile());){
                StoredConfig gitConfig = git.getRepository().getConfig();
                setEncodedPolicyFn.accept((Config)gitConfig, encodedPolicy);
                gitConfig.save();
                logger.chat(Message.localized("fastback.chat.retention-policy-set", new Object[0]));
                logger.chat(rp.getDescription());
            }
            catch (Exception e) {
                logger.internalError("Command execution failed.", e);
                return Commands.FAILURE;
            }
            return Commands.SUCCESS;
        }
        catch (Exception e) {
            logger.internalError("Failed to set retention policy", e);
            return Commands.FAILURE;
        }
    }
}

