/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.SchedulableAction;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;

enum SetShutdownActionCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "set-shutdown-action";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, ModContext ctx) {
        LiteralArgumentBuilder setCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(ctx, COMMAND_NAME));
        for (SchedulableAction action : SchedulableAction.values()) {
            LiteralArgumentBuilder azz = class_2170.method_9247((String)action.getArgumentName());
            azz.executes(cc -> SetShutdownActionCommand.setShutdownAction(ctx, (class_2168)cc.getSource(), action));
            setCommand.then((ArgumentBuilder)azz);
        }
        argb.then((ArgumentBuilder)setCommand);
    }

    private static int setShutdownAction(ModContext ctx, class_2168 scs, SchedulableAction action) {
        Logger log = Commands.commandLogger(ctx, scs);
        Commands.gitOp(ctx, ModContext.ExecutionLock.WRITE_CONFIG, log, git -> {
            StoredConfig config = git.getRepository().getConfig();
            WorldConfig.setShutdownAction((Config)config, action);
            config.save();
            log.chat(Message.localized("fastback.chat.info-shutdown-action", action.getArgumentName()));
        });
        return Commands.SUCCESS;
    }
}

