/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.tasks.ListSnapshotsTask;
import net.pcal.fastback.utils.SnapshotId;
import org.eclipse.jgit.api.Git;

abstract class SnapshotNameSuggestions
implements SuggestionProvider<class_2168> {
    private final ModContext ctx;

    static SnapshotNameSuggestions local(ModContext ctx) {
        return new SnapshotNameSuggestions(ctx){

            @Override
            protected Collection<SnapshotId> getSnapshotIds(Git git, Logger log) throws Exception {
                WorldConfig wc = WorldConfig.load(git);
                return SnapshotId.sortWorldSnapshots(ListSnapshotsTask.listSnapshots(git, log), wc.worldUuid());
            }
        };
    }

    static SnapshotNameSuggestions remote(ModContext ctx) {
        return new SnapshotNameSuggestions(ctx){

            @Override
            protected Collection<SnapshotId> getSnapshotIds(Git git, Logger log) throws Exception {
                WorldConfig wc = WorldConfig.load(git);
                return SnapshotId.sortWorldSnapshots(ListSnapshotsTask.listRemoteSnapshots(git, wc, log), wc.worldUuid());
            }
        };
    }

    private SnapshotNameSuggestions(ModContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> cc, SuggestionsBuilder builder) {
        CompletableFuture<Suggestions> completableFuture = new CompletableFuture<Suggestions>();
        Logger log = Commands.commandLogger(this.ctx, (class_2168)cc.getSource());
        Commands.gitOp(this.ctx, ModContext.ExecutionLock.NONE, log, git -> {
            for (SnapshotId sid : this.getSnapshotIds(git, log)) {
                builder.suggest(sid.getName());
            }
            completableFuture.complete((Suggestions)builder.buildFuture().get());
        });
        return completableFuture;
    }

    protected abstract Collection<SnapshotId> getSnapshotIds(Git var1, Logger var2) throws Exception;
}

