/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.fabric;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_32;
import net.minecraft.server.MinecraftServer;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.fabric.mixins.ServerAccessors;
import net.pcal.fastback.fabric.mixins.SessionAccessors;
import net.pcal.fastback.logging.Log4jLogger;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import org.apache.logging.log4j.LogManager;

public abstract class FabricProvider
implements ModContext.FrameworkServiceProvider {
    private static FabricProvider INSTANCE;
    private MinecraftServer minecraftServer;
    private Runnable autoSaveListener;
    private static final String MOD_ID = "fastback";
    private boolean isWorldSaveEnabled = true;
    private final Logger logger = new Log4jLogger(LogManager.getLogger((String)"fastback"));

    public static FabricProvider getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("not initialized");
        }
        return INSTANCE;
    }

    protected FabricProvider() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    void setMinecraftServer(MinecraftServer serverOrNull) {
        if (serverOrNull == null == (this.minecraftServer == null)) {
            throw new IllegalStateException();
        }
        this.minecraftServer = serverOrNull;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getMinecraftVersion() {
        return class_155.method_16673().method_48019();
    }

    @Override
    public Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public String getModId() {
        return MOD_ID;
    }

    @Override
    public String getModVersion() {
        Optional optionalModContainer = FabricLoader.getInstance().getModContainer(MOD_ID);
        if (optionalModContainer.isEmpty()) {
            throw new IllegalStateException("Could not find loader for fastback");
        }
        ModMetadata m = ((ModContainer)optionalModContainer.get()).getMetadata();
        return String.valueOf(m.getVersion());
    }

    @Override
    public boolean isWorldSaveEnabled() {
        return this.isWorldSaveEnabled;
    }

    @Override
    public void setWorldSaveEnabled(boolean enabled) {
        this.isWorldSaveEnabled = enabled;
    }

    @Override
    public void saveWorld() {
        if (this.minecraftServer == null) {
            throw new IllegalStateException();
        }
        this.minecraftServer.method_39218(false, true, true);
    }

    @Override
    public boolean isServerStopping() {
        if (this.minecraftServer == null) {
            throw new IllegalStateException();
        }
        return this.minecraftServer.method_3750() || this.minecraftServer.method_16043();
    }

    @Override
    public void sendFeedback(Message message, class_2168 scs) {
        scs.method_9226(() -> FabricProvider.messageToText(message), false);
    }

    @Override
    public void sendError(Message message, class_2168 scs) {
        scs.method_9213(FabricProvider.messageToText(message));
    }

    @Override
    public void setAutoSaveListener(Runnable runnable) {
        if (this.autoSaveListener != null) {
            throw new IllegalStateException();
        }
        this.autoSaveListener = Objects.requireNonNull(runnable);
    }

    @Override
    public Path getWorldDirectory() {
        if (this.minecraftServer == null) {
            throw new IllegalStateException();
        }
        class_32.class_5143 session = ((ServerAccessors)this.minecraftServer).getSession();
        return ((SessionAccessors)session).getDirectory().comp_732();
    }

    @Override
    public String getWorldName() {
        if (this.minecraftServer == null) {
            throw new IllegalStateException();
        }
        class_32.class_5143 session = ((ServerAccessors)this.minecraftServer).getSession();
        return session.method_29584().method_35505().method_27339();
    }

    public void autoSaveCompleted() {
        if (this.autoSaveListener != null) {
            this.autoSaveListener.run();
        } else {
            this.getLogger().warn("Autosave just happened but, unexpectedly, no one is listening.");
        }
    }

    static class_2561 messageToText(Message m) {
        if (m.localized() != null) {
            return class_2561.method_43469((String)m.localized().key(), (Object[])m.localized().params());
        }
        return class_2561.method_43470((String)m.raw());
    }
}

