/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.logging;

import java.util.Objects;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;

public class ChatLogger
implements Logger {
    private final ModContext ctx;

    public ChatLogger(ModContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    @Override
    public void chat(Message message, Logger.ChatMessageType type) {
        switch (type) {
            case NORMAL: {
                this.ctx.sendClientChatMessage(message);
                break;
            }
            case ERROR: {
                this.ctx.sendClientChatMessage(message);
            }
        }
    }

    @Override
    public void internalError(String message, Throwable t) {
        this.ctx.sendClientChatMessage(Message.localized("fastback.chat.internal-error", new Object[0]));
    }

    @Override
    public void hud(Message message) {
    }

    @Override
    public void warn(String message) {
    }

    @Override
    public void info(String message) {
    }

    @Override
    public void debug(String message) {
    }

    @Override
    public void debug(String message, Throwable t) {
    }
}

