/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.logging;

import java.util.List;
import java.util.Objects;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;

public class CompositeLogger
implements Logger {
    private final Iterable<Logger> delegates;

    public static Logger of(Logger ... loggers) {
        return new CompositeLogger(List.of(loggers));
    }

    public CompositeLogger(Iterable<Logger> delegates) {
        this.delegates = Objects.requireNonNull(delegates);
    }

    @Override
    public void chat(Message message, Logger.ChatMessageType type) {
        this.delegates.forEach(d -> d.chat(message, type));
    }

    @Override
    public void hud(Message message) {
        this.delegates.forEach(d -> d.hud(message));
    }

    @Override
    public void internalError(String message, Throwable t) {
        this.delegates.forEach(d -> d.internalError(message, t));
    }

    @Override
    public void warn(String message) {
        this.delegates.forEach(d -> d.warn(message));
    }

    @Override
    public void info(String message) {
        this.delegates.forEach(d -> d.info(message));
    }

    @Override
    public void debug(String message) {
        this.delegates.forEach(d -> d.debug(message));
    }

    @Override
    public void debug(String message, Throwable t) {
        this.delegates.forEach(d -> d.debug(message, t));
    }
}

