/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.progress;

import org.eclipse.jgit.lib.ProgressMonitor;

public abstract class PercentageProgressMonitor
implements ProgressMonitor {
    private String currentTask;
    private int currentTotalWork;
    private int totalCompleted;

    protected PercentageProgressMonitor() {
    }

    public final void start(int totalTasks) {
    }

    public final void beginTask(String taskName, int totalWork) {
        this.currentTask = taskName;
        this.currentTotalWork = totalWork;
        this.totalCompleted = 0;
        this.progressStart(this.currentTask);
    }

    public final void update(int completed) {
        this.totalCompleted += completed;
        int percent = this.currentTotalWork == 0 ? 0 : this.totalCompleted * 100 / this.currentTotalWork;
        this.progressUpdate(this.currentTask, percent);
    }

    public final void endTask() {
        this.progressDone(this.currentTask);
        this.currentTask = null;
    }

    public final boolean isCancelled() {
        return false;
    }

    protected abstract void progressStart(String var1);

    protected abstract void progressUpdate(String var1, int var2);

    protected abstract void progressDone(String var1);
}

