/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.retention;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyType;
import net.pcal.fastback.utils.SnapshotId;

class DailyRetentionPolicy
implements RetentionPolicy {
    private static final String GRACE_PERIOD_DAYS = "gracePeriodDays";
    private static final int DEFAULT_GRACE_PERIOD_DAYS = 3;
    private static final String L10N_KEY = "fastback.retain.daily.description";
    private final int gracePeriod;
    private final ModContext ctx;

    public DailyRetentionPolicy(int gracePeriod, ModContext ctx) {
        this.gracePeriod = gracePeriod;
        this.ctx = ctx;
    }

    @Override
    public Message getDescription() {
        return Message.localized(L10N_KEY, this.gracePeriod);
    }

    @Override
    public Collection<SnapshotId> getSnapshotsToPrune(NavigableSet<SnapshotId> snapshots) {
        LocalDate today = LocalDate.now(this.ctx.getTimeZone().toZoneId());
        LocalDate gracePeriodStart = today.minus(Period.ofDays(this.gracePeriod));
        ArrayList<SnapshotId> toPrune = new ArrayList<SnapshotId>();
        LocalDate previousDate = null;
        for (SnapshotId sid : snapshots.descendingSet()) {
            LocalDate currentDate = sid.snapshotDate().toInstant().atZone(this.ctx.getTimeZone().toZoneId()).toLocalDate();
            if (previousDate != null) {
                if (currentDate.isAfter(gracePeriodStart)) {
                    this.ctx.getLogger().debug("Will retain " + sid + " because still in the grace period");
                    continue;
                }
                if (currentDate.equals(previousDate)) {
                    this.ctx.getLogger().debug("Will prune " + sid + " same day as " + currentDate);
                    toPrune.add(sid);
                } else {
                    this.ctx.getLogger().debug("Will retain " + sid + " NOT same day as " + currentDate);
                }
            }
            previousDate = currentDate;
        }
        return toPrune;
    }

    public static enum DailyRetentionPolicyType implements RetentionPolicyType
    {
        INSTANCE;


        @Override
        public String getName() {
            return "daily";
        }

        @Override
        public List<RetentionPolicyType.Parameter> getParameters() {
            return List.of(new RetentionPolicyType.Parameter(DailyRetentionPolicy.GRACE_PERIOD_DAYS, (ArgumentType<?>)IntegerArgumentType.integer((int)0)));
        }

        @Override
        public RetentionPolicy createPolicy(ModContext ctx, Map<String, String> config) {
            int gracePeriodTemp = 3;
            if (config != null && config.containsKey(DailyRetentionPolicy.GRACE_PERIOD_DAYS)) {
                try {
                    gracePeriodTemp = Integer.parseInt(config.get(DailyRetentionPolicy.GRACE_PERIOD_DAYS));
                }
                catch (NumberFormatException nfe) {
                    ctx.getLogger().internalError("invalid grace period " + config.get(DailyRetentionPolicy.GRACE_PERIOD_DAYS), nfe);
                }
            }
            int gracePeriod = gracePeriodTemp;
            return new DailyRetentionPolicy(gracePeriod, ctx);
        }

        @Override
        public Message getDescription() {
            return Message.localized(DailyRetentionPolicy.L10N_KEY, "<gracePeriodDays>");
        }
    }
}

