/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.retention;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyType;
import net.pcal.fastback.utils.SnapshotId;

class FixedCountRetentionPolicy
implements RetentionPolicy {
    private static final int COUNT_DEFAULT = 10;
    private static final String POLICY_NAME = "fixed";
    private static final String L10N_KEY = "fastback.retain.fixed.description";
    private static final String COUNT_PARAM = "count";
    private final ModContext ctx;
    private final int count;

    public static FixedCountRetentionPolicy create(Map<String, String> config, ModContext ctx) {
        int count = 10;
        if (config != null && config.containsKey(COUNT_PARAM)) {
            try {
                count = Integer.parseInt(config.get(COUNT_PARAM));
            }
            catch (NumberFormatException nfe) {
                ctx.getLogger().internalError("invalid count " + config.get(COUNT_PARAM), nfe);
            }
        }
        return new FixedCountRetentionPolicy(ctx, count);
    }

    private FixedCountRetentionPolicy(ModContext ctx, int count) {
        this.ctx = ctx;
        this.count = count;
    }

    @Override
    public Message getDescription() {
        return Message.localized(L10N_KEY, this.count);
    }

    @Override
    public Collection<SnapshotId> getSnapshotsToPrune(NavigableSet<SnapshotId> fromSnapshots) {
        ArrayList<SnapshotId> sorted = new ArrayList<SnapshotId>(fromSnapshots);
        sorted.sort(Collections.reverseOrder());
        if (sorted.size() > this.count) {
            return sorted.subList(this.count - 1, sorted.size() - 1);
        }
        return Collections.emptySet();
    }

    static enum Type implements RetentionPolicyType
    {
        INSTANCE;


        @Override
        public String getName() {
            return FixedCountRetentionPolicy.POLICY_NAME;
        }

        @Override
        public List<RetentionPolicyType.Parameter> getParameters() {
            return List.of(new RetentionPolicyType.Parameter(FixedCountRetentionPolicy.COUNT_PARAM, (ArgumentType<?>)IntegerArgumentType.integer((int)1)));
        }

        @Override
        public RetentionPolicy createPolicy(ModContext ctx, Map<String, String> config) {
            return FixedCountRetentionPolicy.create(config, ctx);
        }

        @Override
        public Message getDescription() {
            return Message.localized(FixedCountRetentionPolicy.L10N_KEY, "<count>");
        }
    }
}

