/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.retention;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.function.Supplier;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyType;
import net.pcal.fastback.utils.SnapshotId;

class GFSRetentionPolicy
implements RetentionPolicy {
    private static final String L10N_KEY = "fastback.retain.gfs.description";
    private final ModContext ctx;
    Supplier<LocalDate> nowSupplier = () -> LocalDate.now(this.ctx.getTimeZone().toZoneId());

    public GFSRetentionPolicy(ModContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Message getDescription() {
        return Message.localized(L10N_KEY, new Object[0]);
    }

    @Override
    public Collection<SnapshotId> getSnapshotsToPrune(NavigableSet<SnapshotId> snapshots) {
        ArrayList<SnapshotId> toPrune = new ArrayList<SnapshotId>();
        LocalDate now = LocalDate.now(this.ctx.getTimeZone().toZoneId());
        LocalDate gracePeriodStart = now.minus(Period.ofDays(2));
        LocalDate oneWeekAgo = now.minus(Period.ofDays(7));
        LocalDate oneMonthAgo = now.minus(Period.ofDays(30));
        Integer currentDay = null;
        Integer currentWeek = null;
        Integer currentMonth = null;
        for (SnapshotId sid : snapshots.descendingSet()) {
            LocalDate snapshotDate = sid.snapshotDate().toInstant().atZone(this.ctx.getTimeZone().toZoneId()).toLocalDate();
            if (snapshotDate.isAfter(gracePeriodStart)) {
                this.ctx.getLogger().debug("Will retain " + sid + " because still in the grace period");
                continue;
            }
            if (snapshotDate.isAfter(oneWeekAgo)) {
                int snapshotDay = snapshotDate.get(ChronoField.DAY_OF_MONTH);
                if (currentDay == null || currentDay != snapshotDay) {
                    currentDay = snapshotDay;
                    continue;
                }
                toPrune.add(sid);
                continue;
            }
            if (snapshotDate.isAfter(oneMonthAgo)) {
                int snapshotWeek = snapshotDate.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
                if (currentWeek == null || currentWeek != snapshotWeek) {
                    currentWeek = snapshotWeek;
                    continue;
                }
                toPrune.add(sid);
                continue;
            }
            int snapshotMonth = snapshotDate.get(ChronoField.MONTH_OF_YEAR);
            if (currentMonth == null || snapshotMonth != currentMonth) {
                currentMonth = snapshotMonth;
                continue;
            }
            toPrune.add(sid);
        }
        return toPrune;
    }

    public static enum GFSRetentionPolicyType implements RetentionPolicyType
    {
        INSTANCE;


        @Override
        public String getName() {
            return "gfs";
        }

        @Override
        public List<RetentionPolicyType.Parameter> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public RetentionPolicy createPolicy(ModContext ctx, Map<String, String> config) {
            return new GFSRetentionPolicy(ctx);
        }

        @Override
        public Message getDescription() {
            return Message.localized(GFSRetentionPolicy.L10N_KEY, new Object[0]);
        }
    }
}

