/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.retention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyType;

public enum RetentionPolicyCodec {
    INSTANCE;


    public RetentionPolicy decodePolicy(ModContext ctx, List<RetentionPolicyType> availablePolicyTypes, String encodedPolicyOriginal) {
        String encodedTypeName;
        Map<String, String> config;
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(availablePolicyTypes);
        Objects.requireNonNull(encodedPolicyOriginal);
        String encodedPolicy = encodedPolicyOriginal.trim();
        int firstSpace = encodedPolicy.indexOf(32);
        if (firstSpace == -1) {
            config = null;
            encodedTypeName = encodedPolicy.trim();
        } else {
            encodedTypeName = encodedPolicy.substring(0, firstSpace).trim();
            config = RetentionPolicyCodec.decodeMap(ctx, encodedPolicy.substring(firstSpace + 1));
        }
        for (RetentionPolicyType rtp : availablePolicyTypes) {
            if (!rtp.getEncodedName().equals(encodedTypeName)) continue;
            return rtp.createPolicy(ctx, config);
        }
        ctx.getLogger().internalError("Invalid retention policy " + encodedPolicy, new Exception());
        return null;
    }

    public String encodePolicy(ModContext ctx, RetentionPolicyType policyType, Map<String, String> config) {
        return policyType.getEncodedName() + " " + RetentionPolicyCodec.encodeMap(ctx, config);
    }

    static final String encodeMap(ModContext ctx, Map<String, String> map) {
        StringBuilder out = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        boolean isFirst = true;
        for (String key : keys) {
            if (!RetentionPolicyCodec.isValidForEncode(key)) {
                ctx.getLogger().internalError("Ignoring invalid key " + key, new Exception());
                continue;
            }
            String value = map.get(key);
            if (!RetentionPolicyCodec.isValidForEncode(value)) {
                ctx.getLogger().internalError("Ignoring invalid value " + value, new Exception());
                continue;
            }
            if (!isFirst) {
                out.append(' ');
            } else {
                isFirst = false;
            }
            out.append(key);
            out.append('=');
            out.append(value);
        }
        return out.toString();
    }

    static final Map<String, String> decodeMap(ModContext ctx, String encodedMap) {
        String[] tokens;
        HashMap<String, String> out = new HashMap<String, String>();
        for (String token : tokens = encodedMap.split(" ")) {
            Object[] keyVal = token.split("=");
            if (keyVal.length != 2) {
                ctx.getLogger().internalError("Ignoring invalid token " + Arrays.toString(keyVal), new Exception());
                continue;
            }
            out.put(((String)keyVal[0]).trim(), ((String)keyVal[1]).trim());
        }
        return out;
    }

    private static boolean isValidForEncode(String keyOrVal) {
        return !keyOrVal.contains("=") && !keyOrVal.contains(" ");
    }
}

