/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.utils.SnapshotId;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;

public class CommitTask
implements Callable<SnapshotId> {
    private final ModContext ctx;
    private final Logger log;
    private final Git git;

    public CommitTask(Git git, ModContext ctx, Logger log) {
        this.git = Objects.requireNonNull(git);
        this.ctx = Objects.requireNonNull(ctx);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public SnapshotId call() throws GitAPIException, IOException {
        this.log.hud(Message.localized("fastback.hud.local-saving", new Object[0]));
        SnapshotId newSid = SnapshotId.create(WorldConfig.getWorldUuid(this.git));
        this.log.info("Preparing local backup " + newSid);
        String newBranchName = newSid.getBranchName();
        CommitTask.doCommit(this.git, this.ctx, newBranchName, this.log);
        this.log.info("Local backup complete.");
        return newSid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCommit(Git git, ModContext ctx, String newBranchName, Logger log) throws GitAPIException {
        log.debug("doing commit");
        log.debug("checkout");
        git.checkout().setOrphan(true).setName(newBranchName).call();
        git.reset().setMode(ResetCommand.ResetType.SOFT).call();
        log.debug("status");
        Status status = git.status().call();
        try {
            log.info("Disabling world save for 'git add'");
            ctx.setWorldSaveEnabled(false);
            ArrayList toAdd = new ArrayList();
            toAdd.addAll(status.getModified());
            toAdd.addAll(status.getUntracked());
            if (!toAdd.isEmpty()) {
                log.info("Adding " + toAdd.size() + " new or modified files to index");
                AddCommand gitAdd = git.add();
                for (String file : toAdd) {
                    log.debug("add  " + file);
                    gitAdd.addFilepattern(file);
                }
                gitAdd.call();
            }
            ArrayList toDelete = new ArrayList();
            toDelete.addAll(status.getRemoved());
            toDelete.addAll(status.getMissing());
            if (!toDelete.isEmpty()) {
                log.info("Removing " + toDelete.size() + " deleted files from index");
                RmCommand gitRm = git.rm();
                for (String file : toDelete) {
                    log.debug("rm  " + file);
                    gitRm.addFilepattern(file);
                }
                gitRm.call();
            }
        }
        finally {
            ctx.setWorldSaveEnabled(true);
            log.info("World save re-enabled.");
        }
        log.debug("commit");
        git.commit().setMessage(newBranchName).call();
    }
}

